/*
 * Decompiled with CFR 0.152.
 */
package ai.connectif.sdk.webview;

import ai.connectif.sdk.manager.Logger;
import ai.connectif.sdk.webview.ConnectifJSBridge;
import android.content.Context;
import android.webkit.WebSettings;
import android.webkit.WebView;
import java.io.BufferedReader;
import java.io.Closeable;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.Charset;
import kotlin.ExceptionsKt;
import kotlin.Metadata;
import kotlin.io.CloseableKt;
import kotlin.io.TextStreamsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.Charsets;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006J\u000e\u0010\u0007\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006J\u0010\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0002\u00a8\u0006\f"}, d2={"Lai/connectif/sdk/webview/ConnectifJSHelper;", "", "()V", "addJSInterface", "", "webView", "Landroid/webkit/WebView;", "syncTrackerId", "syncTrackerIdScript", "", "context", "Landroid/content/Context;", "connectif-android-sdk_release"})
@SourceDebugExtension(value={"SMAP\nConnectifJSHelper.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ConnectifJSHelper.kt\nai/connectif/sdk/webview/ConnectifJSHelper\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,39:1\n1#2:40\n*E\n"})
public final class ConnectifJSHelper {
    @NotNull
    public static final ConnectifJSHelper INSTANCE = new ConnectifJSHelper();

    private ConnectifJSHelper() {
    }

    public final void addJSInterface(@NotNull WebView webView) {
        Intrinsics.checkNotNullParameter((Object)webView, (String)"webView");
        WebSettings webSettings = webView.getSettings();
        Intrinsics.checkNotNullExpressionValue((Object)webSettings, (String)"getSettings(...)");
        WebSettings settings = webSettings;
        if (!settings.getJavaScriptEnabled() || !settings.getDomStorageEnabled()) {
            Logger.INSTANCE.e("WebView settings are incorrect. JavaScript or DOM Storage is disabled.");
            return;
        }
        webView.addJavascriptInterface((Object)new ConnectifJSBridge(), "connectifJSBridge");
    }

    public final void syncTrackerId(@NotNull WebView webView) {
        Intrinsics.checkNotNullParameter((Object)webView, (String)"webView");
        try {
            Context context = webView.getContext();
            Intrinsics.checkNotNullExpressionValue((Object)context, (String)"getContext(...)");
            String script = this.syncTrackerIdScript(context);
            webView.evaluateJavascript(script, ConnectifJSHelper::syncTrackerId$lambda$0);
        }
        catch (Exception e) {
            Logger.INSTANCE.e(ExceptionsKt.stackTraceToString((Throwable)e));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final String syncTrackerIdScript(Context context) {
        InputStream inputStream = context.getAssets().open("webview-on-page-finish.js");
        Intrinsics.checkNotNullExpressionValue((Object)inputStream, (String)"open(...)");
        Closeable closeable = inputStream;
        Object object = Charsets.UTF_8;
        Object object2 = new InputStreamReader((InputStream)closeable, (Charset)object);
        int n = 8192;
        closeable = object2 instanceof BufferedReader ? (BufferedReader)object2 : new BufferedReader((Reader)object2, n);
        object = null;
        try {
            BufferedReader it = (BufferedReader)closeable;
            boolean bl = false;
            object2 = TextStreamsKt.readText((Reader)it);
        }
        catch (Throwable throwable) {
            object = throwable;
            throw throwable;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)object);
        }
        return object2;
    }

    private static final void syncTrackerId$lambda$0(String it) {
    }
}

