package ai.connectif.sdk.webview

import ai.connectif.sdk.manager.Logger
import android.content.Context
import android.webkit.WebView

object ConnectifJSHelper {

    fun addJSInterface(webView: WebView) {
        val settings = webView.settings
        if (!settings.javaScriptEnabled || !settings.domStorageEnabled) {
            Logger.e(
                "WebView settings are incorrect. JavaScript or DOM Storage is disabled."
            )
            return
        }

        webView.addJavascriptInterface(ConnectifJSBridge(), "connectifJSBridge")
    }

    fun syncTrackerId(webView: WebView) {
        try {
            val script = syncTrackerIdScript(webView.context)
            webView.evaluateJavascript(script) {
            }
        } catch (e: Exception) {
            Logger.e(e.stackTraceToString())
        }

        return
    }

    private fun syncTrackerIdScript(context: Context): String {
        return context.assets.open(
            "webview-on-page-finish.js"
        ).bufferedReader().use { it.readText() }
    }
}
