package ai.connectif.sdk.model

import ai.connectif.sdk.Utils.truncate
import ai.connectif.sdk.data.model.event.SearchInternal

data class Search(var searchText: String) {
    internal fun mapToSearchEventInternal(): SearchInternal {
        require(searchText != "") { "searchText cannot be empty string" }

        return SearchInternal(truncate(this.searchText, 50).toString())
    }
}
