package ai.connectif.sdk.model

import ai.connectif.sdk.Utils.truncate
import ai.connectif.sdk.data.model.event.PurchaseInternal
import java.math.BigDecimal
import java.util.Date

data class Purchase(
    val purchaseId: String,
    val products: List<ProductBasketItem>,
    val totalQuantity: Int,
    val totalPrice: BigDecimal,
    val cartId: String,
    val paymentMethod: String?,
    val purchaseDate: Date?
) {
    internal fun mapToPurchaseInternal(): PurchaseInternal {
        require(purchaseId.length <= 50) { "purchaseId cannot have a length greater than 50" }
        require(cartId != "") { "cartId cannot be empty" }
        require(cartId.length <= 50) { "cartId cannot have a length greater than 50" }
        require(totalQuantity >= 1) { "totalQuantity should be greater than or equal to 1" }
        require(products.isNotEmpty()) { "products cannot be empty" }

        return PurchaseInternal(
            purchaseId,
            products.map { it.mapToProductBasketItemInternal() },
            totalQuantity,
            totalPrice,
            truncate(paymentMethod, 50),
            cartId,
            purchaseDate
        )
    }
}
