package ai.connectif.sdk.model

import ai.connectif.sdk.Utils.truncate
import ai.connectif.sdk.data.model.event.PageVisitInternal

data class PageVisit(var pageName: String) {
    internal fun mapToPageVisitEventInternal(): PageVisitInternal {
        require(pageName != "") { "pageName cannot be empty string" }

        return PageVisitInternal(
            truncate(this.pageName, 50).toString()
        )
    }
}
