package ai.connectif.sdk.model

import ai.connectif.sdk.Utils.isValidEmail
import ai.connectif.sdk.data.model.event.LoginInternal

data class Login(val email: String) {
    internal fun mapToLoginEventInternal(): LoginInternal {
        require(isValidEmail(this.email)) { "Invalid email ${this.email}" }
        return LoginInternal(this.email)
    }
}
