package ai.connectif.sdk.model

import ai.connectif.sdk.Utils.isValidPhone
import ai.connectif.sdk.Utils.truncate
import ai.connectif.sdk.data.model.event.ContactInfoInternal
import ai.connectif.sdk.manager.Logger
import java.util.Date

data class ContactInfo(
    val name: String? = null,
    val surname: String? = null,
    val birthdate: Date? = null,
    val mobilePhone: String? = null
) {
    internal fun mapToContactInfoInternal(): ContactInfoInternal {
        val mobilePhone = if (this.mobilePhone.isNullOrEmpty() || isValidPhone(this.mobilePhone)) {
            this.mobilePhone
        } else {
            Logger.e("Error occurred: '${this.mobilePhone}' is not a valid phone")
            ""
        }

        return ContactInfoInternal(
            truncate(this.name, 150),
            truncate(this.surname, 150),
            this.birthdate,
            mobilePhone
        )
    }
}
