package ai.connectif.sdk.model

import ai.connectif.sdk.data.model.event.CartInternal
import java.math.BigDecimal

data class Cart(
    val cartId: String,
    val products: List<ProductBasketItem>,
    val totalQuantity: Int,
    val totalPrice: BigDecimal
) {
    internal fun mapToCartInternal(): CartInternal {
        require(this.cartId != "") { "cartId cannot be empty" }
        require(this.cartId.length <= 50) { "cartId cannot have a length greater than 50" }

        return CartInternal(
            this.cartId,
            this.products.map { it.mapToProductBasketItemInternal() },
            this.totalPrice,
            this.totalQuantity
        )
    }
}
