package ai.connectif.sdk.data.source.typeadapter

import ai.connectif.sdk.Utils
import com.google.gson.JsonElement
import com.google.gson.JsonPrimitive
import com.google.gson.JsonSerializationContext
import com.google.gson.JsonSerializer
import java.lang.reflect.Type
import java.util.Date

class DateTypeAdapter : JsonSerializer<Date> {
    override fun serialize(
        src: Date?,
        typeOfSrc: Type?,
        context: JsonSerializationContext?
    ): JsonElement {
        return if (src != null) {
            JsonPrimitive(Utils.formatToIso8601Utc(src))
        } else {
            JsonPrimitive("")
        }
    }
}
