package ai.connectif.sdk.data.source

import ai.connectif.sdk.BuildConfig
import ai.connectif.sdk.data.ObjectId
import ai.connectif.sdk.data.source.typeadapter.CustomEventTypeAdapter
import ai.connectif.sdk.data.source.typeadapter.CustomEventValueTypeAdapter
import ai.connectif.sdk.data.source.typeadapter.DateTypeAdapter
import ai.connectif.sdk.data.source.typeadapter.ObjectIdTypeAdapter
import ai.connectif.sdk.model.customevent.CustomEvent
import ai.connectif.sdk.model.customevent.CustomEventValue
import com.google.gson.GsonBuilder
import java.util.Date
import okhttp3.OkHttpClient
import okhttp3.logging.HttpLoggingInterceptor
import retrofit2.Retrofit
import retrofit2.converter.gson.GsonConverterFactory

object RetrofitClient {

    private var retrofit: Retrofit? = null

    fun getInstance(): Retrofit {
        if (retrofit == null) {
            val gson = GsonBuilder()
                .registerTypeAdapter(ObjectId::class.java, ObjectIdTypeAdapter())
                .registerTypeHierarchyAdapter(
                    CustomEventValue::class.java,
                    CustomEventValueTypeAdapter()
                )
                .registerTypeAdapter(CustomEvent::class.java, CustomEventTypeAdapter())
                .registerTypeAdapter(Date::class.java, DateTypeAdapter())
                .create()

            val interceptor = HttpLoggingInterceptor().apply {
                level = if (BuildConfig.DEV_LOG_ENABLED) {
                    HttpLoggingInterceptor.Level.BODY
                } else {
                    HttpLoggingInterceptor.Level.NONE
                }
            }

            val client = OkHttpClient.Builder()
                .addInterceptor(interceptor)
                .build()

            retrofit = Retrofit.Builder()
                .baseUrl(BuildConfig.CONNECTIF_ENDPOINT)
                .addConverterFactory(GsonConverterFactory.create(gson))
                .client(client)
                .build()
        }
        return retrofit!!
    }
}
