package ai.connectif.sdk.data.repository

import ai.connectif.sdk.data.model.event.CartInternal
import ai.connectif.sdk.data.model.event.ContactInfoInternal
import ai.connectif.sdk.data.model.event.CustomInternal
import ai.connectif.sdk.data.model.event.LoginInternal
import ai.connectif.sdk.data.model.event.PageVisitInternal
import ai.connectif.sdk.data.model.event.ProductVisitInternal
import ai.connectif.sdk.data.model.event.PurchaseInternal
import ai.connectif.sdk.data.model.event.RegisterInternal
import ai.connectif.sdk.data.model.event.SearchInternal
import ai.connectif.sdk.data.model.event.SubscribeNewsletterInternal
import ai.connectif.sdk.data.source.model.response.SendEventResponse

internal interface EventRepository {
    suspend fun sendPageVisit(event: PageVisitInternal): SendEventResponse?

    suspend fun sendSearch(event: SearchInternal): SendEventResponse?

    suspend fun sendProductVisit(event: ProductVisitInternal): SendEventResponse?

    suspend fun sendLogin(event: LoginInternal): SendEventResponse?

    suspend fun sendRegister(event: RegisterInternal): SendEventResponse?

    suspend fun sendCart(event: CartInternal): SendEventResponse?

    suspend fun sendPurchase(event: PurchaseInternal): SendEventResponse?

    suspend fun sendContactInfo(event: ContactInfoInternal): SendEventResponse?

    suspend fun sendCustomEvent(event: CustomInternal): SendEventResponse?

    suspend fun subscribeToNewsletter(event: SubscribeNewsletterInternal): SendEventResponse?
}
