package ai.connectif.sdk.data.model.push

import ai.connectif.sdk.data.model.event.DeviceInfo
import ai.connectif.sdk.data.model.event.Event
import ai.connectif.sdk.data.source.model.request.AddPushTokenRequest

internal data class AddPushTokenInternal(
    var token: String,
    override var trackerId: String? = null,
    override var email: String? = null,
    override var deviceInfo: DeviceInfo? = null
) : Event {
    fun mapToApiModel(): AddPushTokenRequest {
        return AddPushTokenRequest(
            deviceInfo = deviceInfo,
            token = token,
            trackerId = trackerId,
            email = email
        )
    }
}
