package ai.connectif.sdk.data.model.event

import ai.connectif.sdk.data.source.model.request.ProductVisitRequest
import ai.connectif.sdk.model.Product

internal data class ProductVisitInternal(
    var product: Product,
    override var trackerId: String? = null,
    override var email: String? = null,
    override var deviceInfo: DeviceInfo? = null
) : Event {
    fun mapToApiModel(): ProductVisitRequest = ProductVisitRequest(
        deviceInfo = deviceInfo,
        product = product.mapTopProductVisit(),
        trackerId = trackerId,
        email = email
    )
}
