package ai.connectif.sdk.data.model.event

import ai.connectif.sdk.data.source.model.request.PageVisitRequest

internal data class PageVisitInternal(
    var pageName: String,
    override var trackerId: String? = null,
    override var email: String? = null,
    override var deviceInfo: DeviceInfo? = null
) : Event {
    fun mapToApiModel(): PageVisitRequest {
        return PageVisitRequest(
            deviceInfo = deviceInfo,
            trackerId = trackerId,
            email = email,
            pageName = pageName
        )
    }
}
