package ai.connectif.sdk

import ai.connectif.sdk.manager.Logger
import android.webkit.URLUtil
import java.text.SimpleDateFormat
import java.util.Date
import java.util.Locale
import java.util.TimeZone

object Utils {

    fun formatToIso8601Utc(date: Date?): String? {
        if (date == null) return null

        val dateFormat = SimpleDateFormat(Constants.Global.DATE_FORMAT, Locale.getDefault()).apply {
            timeZone = TimeZone.getTimeZone("UTC")
        }

        return dateFormat.format(date)
    }

    fun formatApiKeyToHeader(apiKey: String): String = "apiKey $apiKey"

    fun isValidEmail(email: String): Boolean {
        val emailRegex =
            Regex("^[a-zA-Z0-9.!#\$%&’*+/=?^_`{|}~-]+@[a-zA-Z0-9-]+(?:\\.[a-zA-Z0-9-]+)+\$")
        return email.length <= 200 && email.matches(emailRegex)
    }

    fun isValidPhone(phone: String): Boolean {
        val phoneRegex =
            Regex("^\\+[1-9]\\d{6,14}$")
        return phone.matches(phoneRegex)
    }

    fun truncate(value: String?, maxLength: Int): String? = if (value !== null &&
        value.length > maxLength
    ) {
        Logger.e(
            "'$value' exceeds the maximum length $maxLength and has been truncated"
        )
        value.substring(0, maxLength)
    } else {
        value
    }

    fun truncate(value: List<String>?, maxLength: Int, name: String): List<String>? = if (value !==
        null &&
        value.size > maxLength
    ) {
        Logger.e("$name exceeds the maximum length $maxLength and has been truncated")
        value.subList(0, maxLength)
    } else {
        value
    }

    fun ensurePositive(value: Double?, name: String): Double? = if (value != null && value < 0) {
        Logger.e("$name cannot be a negative number")
        null
    } else {
        value
    }

    fun ensurePositive(value: Int?, name: String): Int? = if (value != null && value < 0) {
        Logger.e("$name cannot be a negative number")
        null
    } else {
        value
    }

    fun requireValidUrl(url: String?, name: String) {
        if (url != null) {
            require(url.length <= 1000) {
                "$name cannot have a length greater than 1000"
            }
            require(URLUtil.isValidUrl(url)) { "$name should be a valid absolute URL" }
        }
    }
}
