package ai.connectif.sdk

import ai.connectif.sdk.manager.LogLevel

/**
 * Configuration for initializing the Connectif SDK.
 *
 * @property pushSmallIcon Resource (drawable) used as the small icon in push notifications
 *                         (default: [R.drawable.ic_default_notification]).
 * @property pushChannelId Identifier for the push notification channel
 *                         (default: "connectif_channel").
 * @property pushChannelName Name displayed for the push notification channel
 *                           (default: "Default Channel").
 * @property logLevel [LogLevel] Logging level that determines how much information is shown
 *                    in the logs (default: [LogLevel.NONE]).
 * @property webViewMode (EXPERIMENTAL) Disable tracking, only enable push notifications
 *                    (default: "false).
 */
data class ConnectifConfig(
    var pushSmallIcon: Int = R.drawable.ic_default_notification,
    var pushChannelId: String = "connectif_channel",
    var pushChannelName: String = "Default Channel",
    var logLevel: LogLevel = LogLevel.NONE,
    var webViewMode: Boolean = false
)
