/*
 * Decompiled with CFR 0.152.
 */
package ai.connectif.sdk.data.source;

import ai.connectif.sdk.data.source.LocalPushTokenDataSource;
import android.content.SharedPreferences;
import java.util.Date;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0010\u000b\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0006H\u0016R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0006X\u0082D\u00a2\u0006\u0002\n\u0000R$\u0010\n\u001a\u00020\t2\u0006\u0010\b\u001a\u00020\t8V@VX\u0096\u000e\u00a2\u0006\f\u001a\u0004\b\u000b\u0010\f\"\u0004\b\r\u0010\u000eR(\u0010\u000f\u001a\u0004\u0018\u00010\u00062\b\u0010\b\u001a\u0004\u0018\u00010\u00068V@VX\u0096\u000e\u00a2\u0006\f\u001a\u0004\b\u0010\u0010\u0011\"\u0004\b\u0012\u0010\u0013R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0017"}, d2={"Lai/connectif/sdk/data/source/LocalPushTokenDataSourceImpl;", "Lai/connectif/sdk/data/source/LocalPushTokenDataSource;", "sharedPreferences", "Landroid/content/SharedPreferences;", "(Landroid/content/SharedPreferences;)V", "keyLastUpdateToken", "", "keyToken", "value", "Ljava/util/Date;", "lastUpdate", "getLastUpdate", "()Ljava/util/Date;", "setLastUpdate", "(Ljava/util/Date;)V", "pushToken", "getPushToken", "()Ljava/lang/String;", "setPushToken", "(Ljava/lang/String;)V", "needSyncToken", "", "token", "connectif-android-sdk_release"})
public final class LocalPushTokenDataSourceImpl
implements LocalPushTokenDataSource {
    @NotNull
    private final SharedPreferences sharedPreferences;
    @NotNull
    private final String keyToken;
    @NotNull
    private final String keyLastUpdateToken;

    public LocalPushTokenDataSourceImpl(@NotNull SharedPreferences sharedPreferences) {
        Intrinsics.checkNotNullParameter((Object)sharedPreferences, (String)"sharedPreferences");
        this.sharedPreferences = sharedPreferences;
        this.keyToken = "keyToken";
        this.keyLastUpdateToken = "keyLastUpdateToken";
    }

    @Override
    @Nullable
    public String getPushToken() {
        return this.sharedPreferences.getString(this.keyToken, null);
    }

    @Override
    public void setPushToken(@Nullable String value) {
        this.sharedPreferences.edit().putString(this.keyToken, value).apply();
    }

    @Override
    @NotNull
    public Date getLastUpdate() {
        long time = this.sharedPreferences.getLong(this.keyLastUpdateToken, 0L);
        return new Date(time);
    }

    @Override
    public void setLastUpdate(@NotNull Date value) {
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        this.sharedPreferences.edit().putLong(this.keyLastUpdateToken, value.getTime()).apply();
    }

    @Override
    public boolean needSyncToken(@NotNull String token) {
        Intrinsics.checkNotNullParameter((Object)token, (String)"token");
        long elapsedHours = (System.currentTimeMillis() - this.getLastUpdate().getTime()) / (long)3600000;
        return !Intrinsics.areEqual((Object)token, (Object)this.getPushToken()) || elapsedHours >= 24L;
    }
}

