package ai.connectif.sdk.model

import ai.connectif.sdk.data.model.event.RegisterInternal
import java.util.Date

data class Register(val email: String, val contactInfo: RegisterContactInfo? = null) {
    internal fun mapToRegisterEventInternal(): RegisterInternal =
        RegisterInternal(email = this.email, contactInfo = this.contactInfo)
}

data class RegisterContactInfo(
    val name: String? = null,
    val surname: String? = null,
    val birthdate: Date? = null,
    val mobilePhone: String? = null,
    val newsletterSubscriptionStatus: SubscriptionStatus? = null,
    val smsSubscriptionStatus: SubscriptionStatus? = null
)
