package ai.connectif.sdk.model

import ai.connectif.sdk.data.model.event.PurchaseInternal
import java.math.BigDecimal
import java.util.Date

data class Purchase(
    val purchaseId: String,
    val products: List<ProductBasketItem>,
    val totalQuantity: Int,
    val totalPrice: BigDecimal,
    val cartId: String?,
    val paymentMethod: String?,
    val purchaseDate: Date?
) {
    internal fun mapToPurchaseInternal(): PurchaseInternal = PurchaseInternal(
        purchaseId,
        products,
        totalQuantity,
        totalPrice,
        paymentMethod,
        cartId,
        purchaseDate
    )
}
