package ai.connectif.sdk.model

import ai.connectif.sdk.data.source.model.request.cart.ProductCartItem
import ai.connectif.sdk.data.source.model.request.purchase.ProductPurchaseItem
import java.math.BigDecimal
import java.util.Date

data class ProductBasketItem(
    val productDetailUrl: String,
    val productId: String,
    val name: String,
    val unitPrice: BigDecimal,
    val description: String? = null,
    val imageUrl: String? = null,
    val categories: List<String>? = null,
    val tags: List<String>? = null,
    val brand: String? = null,
    val reviewCount: Int? = null,
    val rating: Double? = null,
    val ratingCount: Int? = null,
    val thumbnailUrl: String? = null,
    val unitPriceOriginal: BigDecimal? = null,
    val unitPriceWithoutVAT: BigDecimal? = null,
    val discountedAmount: BigDecimal? = null,
    val discountedPercentage: Double? = null,
    val publishedAt: Date? = null,
    val customField1: String? = null,
    val customField2: String? = null,
    val customField3: String? = null,
    val quantity: Int,
    val price: BigDecimal
) {
    internal fun mapToProductPurchaseItem(): ProductPurchaseItem = ProductPurchaseItem(
        productDetailUrl = this.productDetailUrl,
        productId = this.productId,
        name = this.name,
        unitPrice = this.unitPrice,
        description = this.description,
        imageUrl = this.imageUrl,
        categories = this.categories,
        tags = this.tags,
        brand = this.brand,
        reviewCount = this.reviewCount,
        rating = this.rating,
        ratingCount = this.ratingCount,
        thumbnailUrl = this.thumbnailUrl,
        unitPriceOriginal = this.unitPriceOriginal,
        unitPriceWithoutVAT = this.unitPriceWithoutVAT,
        discountedAmount = this.discountedAmount,
        discountedPercentage = this.discountedPercentage,
        publishedAt = this.publishedAt,
        customField1 = this.customField1,
        customField2 = this.customField2,
        customField3 = this.customField3,
        quantity = this.quantity,
        price = this.price
    )

    internal fun mapToProductCartItem(): ProductCartItem = ProductCartItem(
        productDetailUrl = this.productDetailUrl,
        productId = this.productId,
        name = this.name,
        unitPrice = this.unitPrice,
        description = this.description,
        imageUrl = this.imageUrl,
        categories = this.categories,
        tags = this.tags,
        brand = this.brand,
        reviewCount = this.reviewCount,
        rating = this.rating,
        ratingCount = this.ratingCount,
        thumbnailUrl = this.thumbnailUrl,
        unitPriceOriginal = this.unitPriceOriginal,
        unitPriceWithoutVAT = this.unitPriceWithoutVAT,
        discountedAmount = this.discountedAmount,
        discountedPercentage = this.discountedPercentage,
        publishedAt = this.publishedAt,
        customField1 = this.customField1,
        customField2 = this.customField2,
        customField3 = this.customField3,
        quantity = this.quantity,
        price = this.price
    )
}
