package ai.connectif.sdk.model

import ai.connectif.sdk.data.source.model.request.productVisit.ProductRequest
import java.math.BigDecimal
import java.util.Date

data class Product(
    val productDetailUrl: String,
    val productId: String,
    val name: String,
    val unitPrice: BigDecimal,
    val description: String? = null,
    val imageUrl: String? = null,
    val availability: Availability? = null,
    val categories: List<String>? = null,
    val tags: List<String>? = null,
    val brand: String? = null,
    val reviewCount: Int? = null,
    val rating: Double? = null,
    val ratingCount: Int? = null,
    val thumbnailUrl: String? = null,
    val relatedExternalProductIds: List<String>? = null,
    val priority: Int? = null,
    val unitPriceOriginal: BigDecimal? = null,
    val unitPriceWithoutVAT: BigDecimal? = null,
    val discountedAmount: BigDecimal? = null,
    val discountedPercentage: Double? = null,
    val publishedAt: Date? = null,
    val customField1: String? = null,
    val customField2: String? = null,
    val customField3: String? = null
) {
    internal fun mapTopProductVisit(): ProductRequest = ProductRequest(
        productDetailUrl = this.productDetailUrl,
        productId = this.productId,
        name = this.name,
        unitPrice = this.unitPrice,
        description = this.description,
        imageUrl = this.imageUrl,
        availability = this.availability?.value,
        categories = this.categories,
        tags = this.tags,
        brand = this.brand,
        reviewCount = this.reviewCount,
        rating = this.rating,
        ratingCount = this.ratingCount,
        thumbnailUrl = this.thumbnailUrl,
        relatedExternalProductIds = this.relatedExternalProductIds,
        priority = this.priority,
        unitPriceOriginal = this.unitPriceOriginal,
        unitPriceWithoutVAT = this.unitPriceWithoutVAT,
        discountedAmount = this.discountedAmount,
        discountedPercentage = this.discountedPercentage,
        publishedAt = this.publishedAt,
        customField1 = this.customField1,
        customField2 = this.customField2,
        customField3 = this.customField3
    )

    enum class Availability(val value: String) {
        IN_STOCK("instock"),
        OUT_OF_STOCK("outofstock")
    }
}
