package ai.connectif.sdk.model

import ai.connectif.sdk.data.model.event.CartInternal
import java.math.BigDecimal

data class Cart(
    val cartId: String,
    val products: List<ProductBasketItem>,
    val totalQuantity: Int,
    val totalPrice: BigDecimal
) {
    internal fun mapToCartInternal(): CartInternal = CartInternal(
        this.cartId,
        this.products,
        this.totalPrice,
        this.totalQuantity
    )
}
