package ai.connectif.sdk.manager.push

import ai.connectif.sdk.Connectif
import ai.connectif.sdk.Constants
import ai.connectif.sdk.data.model.push.ExtraNotificationData
import ai.connectif.sdk.data.model.push.TrackPushClickData
import ai.connectif.sdk.manager.Logger
import android.app.Activity
import android.app.NotificationManager
import android.content.Context
import android.content.Intent
import android.net.Uri
import android.os.Build
import android.os.Bundle

internal class TrackPushClickActivity : Activity() {

    override fun onCreate(savedInstanceState: Bundle?) {
        super.onCreate(savedInstanceState)
        runCatching {
            trackPushClick()
            handleClose()
        }
        finish()
    }

    fun handleClose() {
        val extraNotificationData = if (Build.VERSION.SDK_INT >= Build.VERSION_CODES.TIRAMISU) {
            intent.getParcelableExtra(
                Constants.PushNotification.EXTRA_NOTIFICATION_DATA,
                ExtraNotificationData::class.java
            )
        } else {
            intent.getParcelableExtra(Constants.PushNotification.EXTRA_NOTIFICATION_DATA)
        }
        extraNotificationData?.let {
            if (it.requestCode != -1) {
                val notificationManager =
                    getSystemService(Context.NOTIFICATION_SERVICE) as NotificationManager
                notificationManager.cancel(it.tag, it.requestCode)
            }
        }
    }

    private fun trackPushClick() {
        val data = if (Build.VERSION.SDK_INT >= Build.VERSION_CODES.TIRAMISU) {
            intent.getParcelableExtra(
                Constants.PushNotification.EXTRA_TRACK_DATA,
                TrackPushClickData::class.java
            )
        } else {
            intent.getParcelableExtra(Constants.PushNotification.EXTRA_TRACK_DATA)
        }
        Connectif.trackPushClick(data)
        sendActionBroadcast(data?.linkUrl)
        data?.linkUrl?.let { resolveUrl(it) } ?: run {
            launchApp(this)
        }
    }

    private fun resolveUrl(url: String) {
        startActivity(Intent(Intent.ACTION_VIEW, Uri.parse(url)))
    }

    internal fun sendActionBroadcast(url: String?) {
        Intent().also { intent ->
            intent.setAction(Constants.PushNotification.ACTION_PUSH_CLICK)
            intent.putExtra(Constants.PushNotification.EXTRA_URL, url)
            intent.`package` = packageName
            sendBroadcast(intent)
        }
    }

    private fun launchApp(context: Context) {
        val packageName = context.packageName
        val launchIntent = context.packageManager.getLaunchIntentForPackage(packageName)
        if (launchIntent != null) {
            launchIntent.addFlags(
                Intent.FLAG_ACTIVITY_NEW_TASK or Intent.FLAG_ACTIVITY_RESET_TASK_IF_NEEDED
            )
            context.startActivity(launchIntent)
        } else {
            Logger.e("Launch intent not available for push click")
        }
    }
}
