package ai.connectif.sdk.manager

import ai.connectif.sdk.BuildConfig
import ai.connectif.sdk.data.model.event.DeviceInfo
import android.content.Context
import android.content.pm.PackageManager
import android.os.Build

internal class DeviceInfoManager(
    private val context: Context,
    private val buildConfigWrapper: BuildConfigWrapper
) {
    private fun getAppVersion(): String {
        return try {
            val pInfo = context.packageManager.getPackageInfo(context.packageName, 0)
            pInfo.versionName
        } catch (e: PackageManager.NameNotFoundException) {
            "Unknown"
        }
    }

    private fun getAndroidVersion(): String {
        return buildConfigWrapper.getAndroidVersion()
    }

    private fun getSDKVersionNane(): String {
        return buildConfigWrapper.getSDKVersionName()
    }

    fun getDeviceInfo(): DeviceInfo {
        return DeviceInfo(
            "android",
            getAppVersion(),
            getAndroidVersion(),
            getSDKVersionNane()
        )
    }
}

class BuildConfigWrapper {
    fun getSDKVersionName(): String {
        return BuildConfig.SDK_VERSION_NAME
    }

    fun getAndroidVersion(): String {
        return Build.VERSION.RELEASE ?: "Unknown"
    }
}
