package ai.connectif.sdk.data.source.typeadapter

import ai.connectif.sdk.Utils
import ai.connectif.sdk.model.customevent.CustomEventValue
import com.google.gson.JsonArray
import com.google.gson.JsonElement
import com.google.gson.JsonPrimitive
import com.google.gson.JsonSerializationContext
import com.google.gson.JsonSerializer
import java.lang.reflect.Type

class CustomEventValueTypeAdapter : JsonSerializer<CustomEventValue> {
    override fun serialize(
        src: CustomEventValue,
        typeOfSrc: Type?,
        context: JsonSerializationContext?
    ): JsonElement {
        return when (src) {
            is CustomEventValue.Text -> JsonPrimitive(src.text)
            is CustomEventValue.Phone -> JsonPrimitive(src.number)
            is CustomEventValue.Email -> JsonPrimitive(src.email)
            is CustomEventValue.Integer -> JsonPrimitive(src.number)
            is CustomEventValue.Decimal -> JsonPrimitive(src.number)
            is CustomEventValue.DateTime -> {
                return JsonPrimitive(Utils.formatToIso8601Utc(src.date))
            }

            is CustomEventValue.Boolean -> JsonPrimitive(src.boolean)
            is CustomEventValue.MultipleChoice -> JsonArray().apply {
                src.choices.forEach {
                    add(
                        JsonPrimitive(it)
                    )
                }
            }

            is CustomEventValue.SingleOption -> JsonPrimitive(src.option)
        }
    }
}
