package ai.connectif.sdk.data.source.typeadapter

import ai.connectif.sdk.model.customevent.CustomEvent
import com.google.gson.JsonElement
import com.google.gson.JsonObject
import com.google.gson.JsonSerializationContext
import com.google.gson.JsonSerializer
import java.lang.reflect.Type

class CustomEventTypeAdapter : JsonSerializer<CustomEvent> {
    override fun serialize(
        src: CustomEvent,
        typeOfSrc: Type?,
        context: JsonSerializationContext?
    ): JsonElement {
        val jsonObject = JsonObject()
        src.values?.forEach { (key, value) ->
            jsonObject.add(key, context?.serialize(value))
        }
        return jsonObject
    }
}
