package ai.connectif.sdk.data.source.model.request.cart

import ai.connectif.sdk.data.model.event.DeviceInfo
import ai.connectif.sdk.data.source.model.request.EventRequest
import java.math.BigDecimal
import java.util.Date

internal data class CartRequest(
    override var deviceInfo: DeviceInfo?,
    val cart: CartApiModel,
    override val trackerId: String?,
    override val email: String?
) : EventRequest

internal data class CartApiModel(
    val cartId: String,
    val products: List<ProductCartItem>,
    val totalQuantity: Int,
    val totalPrice: BigDecimal
)

internal data class ProductCartItem(
    val productDetailUrl: String,
    val productId: String,
    val name: String,
    val unitPrice: BigDecimal,
    val description: String? = null,
    val imageUrl: String? = null,
    val categories: List<String>? = null,
    val tags: List<String>? = null,
    val brand: String? = null,
    val reviewCount: Int? = null,
    val rating: Double? = null,
    val ratingCount: Int? = null,
    val thumbnailUrl: String? = null,
    val unitPriceOriginal: BigDecimal? = null,
    val unitPriceWithoutVAT: BigDecimal? = null,
    val discountedAmount: BigDecimal? = null,
    val discountedPercentage: Double? = null,
    val publishedAt: Date? = null,
    val customField1: String? = null,
    val customField2: String? = null,
    val customField3: String? = null,

    val quantity: Int,
    val price: BigDecimal
)
