package ai.connectif.sdk.data.source

import ai.connectif.sdk.Constants
import android.content.SharedPreferences
import java.util.Date

class LocalPushTokenDataSourceImpl(private val sharedPreferences: SharedPreferences) :
    LocalPushTokenDataSource {
    private val keyToken: String = "keyToken"

    private val keyLastUpdateToken: String = "keyLastUpdateToken"

    override var pushToken: String?
        get() = sharedPreferences.getString(keyToken, null)
        set(value) {
            sharedPreferences.edit().putString(keyToken, value).apply()
        }

    override var lastUpdate: Date
        get() {
            val time = sharedPreferences.getLong(keyLastUpdateToken, 0)
            return Date(time)
        }
        set(value) {
            sharedPreferences.edit().putLong(keyLastUpdateToken, value.time).apply()
        }

    override fun needSyncToken(token: String): Boolean {
        val elapsedHours = (System.currentTimeMillis() - lastUpdate.time) / (1000 * 60 * 60)

        return token != pushToken ||
            elapsedHours >= Constants.PushToken.REFRESH_INTERVAL_HOURS
    }
}
