package ai.connectif.sdk.data.model.event

import ai.connectif.sdk.data.source.model.request.purchase.PurchaseApiModel
import ai.connectif.sdk.data.source.model.request.purchase.PurchaseRequest
import ai.connectif.sdk.model.ProductBasketItem
import java.math.BigDecimal
import java.util.Date

internal data class PurchaseInternal(
    val purchaseId: String,
    val products: List<ProductBasketItem>,
    val totalQuantity: Int,
    val totalPrice: BigDecimal,
    val purchaseMethod: String?,
    val cartId: String?,
    val purchaseDate: Date?,
    override var trackerId: String? = null,
    override var email: String? = null,
    override var deviceInfo: DeviceInfo? = null
) : Event {
    fun mapToApiModel(): PurchaseRequest = PurchaseRequest(
        deviceInfo = deviceInfo,
        purchase = PurchaseApiModel(
            purchaseId,
            products.map { it.mapToProductPurchaseItem() },
            totalQuantity,
            totalPrice,
            cartId,
            purchaseDate,
            purchaseMethod
        ),
        trackerId = trackerId,
        email = email
    )
}
