package ai.connectif.sdk.data.model.event

import ai.connectif.sdk.data.source.model.request.cart.CartApiModel
import ai.connectif.sdk.data.source.model.request.cart.CartRequest
import ai.connectif.sdk.model.ProductBasketItem
import java.math.BigDecimal

internal data class CartInternal(
    val cartId: String,
    val products: List<ProductBasketItem>,
    val totalPrice: BigDecimal,
    val totalQuantity: Int,
    override var trackerId: String? = null,
    override var email: String? = null,
    override var deviceInfo: DeviceInfo? = null
) : Event {
    fun mapToApiModel(): CartRequest {
        val cartApiModel =
            CartApiModel(
                cartId,
                products.map { it.mapToProductCartItem() },
                totalQuantity,
                totalPrice
            )

        return CartRequest(
            deviceInfo = deviceInfo,
            cart = cartApiModel,
            trackerId = trackerId,
            email = email
        )
    }
}
