package ai.connectif.sdk.data

import android.os.Parcelable
import kotlinx.parcelize.Parcelize

@Parcelize
class ObjectId(val value: String) : Parcelable {

    init {
        require(this.isValidObjectId()) {
            "Invalid ObjectID for $value"
        }
    }

    private fun isValidObjectId(): Boolean {
        return value.matches(Regex("^[0-9a-fA-F]{24}\$"))
    }
}
