package ai.connectif.sdk

import java.text.SimpleDateFormat
import java.util.Date
import java.util.Locale
import java.util.TimeZone

object Utils {

    fun formatToIso8601Utc(date: Date?): String? {
        if (date == null) return null

        val dateFormat = SimpleDateFormat(Constants.Global.DATE_FORMAT, Locale.getDefault()).apply {
            timeZone = TimeZone.getTimeZone("UTC")
        }

        return dateFormat.format(date)
    }

    fun formatApiKeyToHeader(apiKey: String): String = "apiKey $apiKey"

    fun isValidEmail(email: String): Boolean {
        val emailRegex =
            Regex("^[a-zA-Z0-9.!#\$%&’*+/=?^_`{|}~-]+@[a-zA-Z0-9-]+(?:\\.[a-zA-Z0-9-]+)+\$")
        return email.matches(emailRegex)
    }
}
