package ai.connectif.sdk

import ai.connectif.sdk.model.Cart
import ai.connectif.sdk.model.ContactInfo
import ai.connectif.sdk.model.EventCallbacks
import ai.connectif.sdk.model.Product
import ai.connectif.sdk.model.Purchase
import ai.connectif.sdk.model.RegisterContactInfo
import ai.connectif.sdk.model.customevent.CustomEvent
import android.content.Context

interface ConnectifInterface {
    fun initialize(
        context: Context,
        apiKey: String,
        email: String?,
        connectifConfig: ConnectifConfig = ConnectifConfig()
    )

    fun addPushToken(token: String, context: Context)

    fun handlePushNotification(data: Map<String, String>, context: Context): Boolean

    fun isConnectifPushNotification(data: Map<String, String>?): Boolean

    fun sendPageVisit(name: String, callbacks: EventCallbacks? = null)

    fun sendSearch(searchText: String, callbacks: EventCallbacks? = null)

    fun sendProductVisit(product: Product, callbacks: EventCallbacks? = null)

    fun sendLogin(email: String, callbacks: EventCallbacks? = null)

    fun sendCart(cart: Cart, callbacks: EventCallbacks? = null)

    fun sendPurchase(purchase: Purchase, callbacks: EventCallbacks? = null)

    fun sendRegister(
        email: String,
        contactInfo: RegisterContactInfo? = null,
        callbacks: EventCallbacks? = null
    )

    fun sendContactInfo(contactInfo: ContactInfo, callbacks: EventCallbacks? = null)

    fun subscribeToNewsletter(callbacks: EventCallbacks? = null)

    fun sendCustomEventById(
        eventId: String,
        customEvent: CustomEvent,
        callbacks: EventCallbacks? = null
    )

    fun sendCustomEventById(eventId: String, payload: Any, callbacks: EventCallbacks? = null)

    fun sendCustomEventByAlias(
        eventAlias: String,
        customEvent: CustomEvent,
        callbacks: EventCallbacks? = null
    )

    fun sendCustomEventByAlias(eventAlias: String, payload: Any, callbacks: EventCallbacks? = null)
}
