package ai.connectif.sdk

import ai.connectif.sdk.data.model.push.TrackPushClickData
import ai.connectif.sdk.manager.Logger
import ai.connectif.sdk.model.Cart
import ai.connectif.sdk.model.ContactInfo
import ai.connectif.sdk.model.EventCallbacks
import ai.connectif.sdk.model.Product
import ai.connectif.sdk.model.Purchase
import ai.connectif.sdk.model.RegisterContactInfo
import ai.connectif.sdk.model.customevent.CustomEvent
import android.content.Context

object Connectif : ConnectifInterface {

    internal var connectifInternal = ConnectifInternal()

    override fun initialize(
        context: Context,
        apiKey: String,
        email: String?,
        connectifConfig: ConnectifConfig
    ) {
        try {
            connectifInternal.initialize(context, apiKey, email, connectifConfig)
        } catch (e: Exception) {
            handleInternalError(e)
        }
    }

    override fun addPushToken(token: String, context: Context) {
        try {
            connectifInternal.addPushToken(token, context)
        } catch (e: Exception) {
            handleInternalError(e)
        }
    }

    override fun handlePushNotification(data: Map<String, String>, context: Context): Boolean =
        try {
            connectifInternal.handlePushNotification(data, context)
        } catch (e: Exception) {
            handleInternalError(e)
            false
        }

    override fun isConnectifPushNotification(data: Map<String, String>?): Boolean = try {
        connectifInternal.isConnectifPushNotification(data)
    } catch (e: Exception) {
        handleInternalError(e)
        false
    }

    override fun sendPageVisit(name: String, callbacks: EventCallbacks?) {
        try {
            connectifInternal.sendPageVisit(name, callbacks)
        } catch (e: Exception) {
            handleInternalError(e)
        }
    }

    override fun sendSearch(searchText: String, callbacks: EventCallbacks?) {
        try {
            connectifInternal.sendSearch(searchText, callbacks)
        } catch (e: Exception) {
            handleInternalError(e)
        }
    }

    override fun sendProductVisit(product: Product, callbacks: EventCallbacks?) {
        try {
            connectifInternal.sendProductVisit(product, callbacks)
        } catch (e: Exception) {
            handleInternalError(e)
        }
    }

    override fun sendLogin(email: String, callbacks: EventCallbacks?) {
        try {
            connectifInternal.sendLogin(email, callbacks)
        } catch (e: Exception) {
            handleInternalError(e)
        }
    }

    override fun sendCart(cart: Cart, callbacks: EventCallbacks?) {
        try {
            connectifInternal.sendCart(cart, callbacks)
        } catch (e: Exception) {
            handleInternalError(e)
        }
    }

    override fun sendPurchase(purchase: Purchase, callbacks: EventCallbacks?) {
        try {
            connectifInternal.sendPurchase(purchase, callbacks)
        } catch (e: Exception) {
            handleInternalError(e)
        }
    }

    override fun sendRegister(
        email: String,
        contactInfo: RegisterContactInfo?,
        callbacks: EventCallbacks?
    ) {
        try {
            connectifInternal.sendRegister(email, contactInfo, callbacks)
        } catch (e: Exception) {
            handleInternalError(e)
        }
    }

    override fun sendContactInfo(contactInfo: ContactInfo, callbacks: EventCallbacks?) {
        try {
            connectifInternal.sendContactInfo(contactInfo, callbacks)
        } catch (e: Exception) {
            handleInternalError(e)
        }
    }

    override fun subscribeToNewsletter(callbacks: EventCallbacks?) {
        try {
            connectifInternal.subscribeToNewsletter(callbacks)
        } catch (e: Exception) {
            handleInternalError(e)
        }
    }

    override fun sendCustomEventById(
        eventId: String,
        customEvent: CustomEvent,
        callbacks: EventCallbacks?
    ) {
        try {
            connectifInternal.sendCustomEventById(eventId, customEvent, callbacks)
        } catch (e: Exception) {
            handleInternalError(e)
        }
    }

    override fun sendCustomEventById(eventId: String, payload: Any, callbacks: EventCallbacks?) {
        try {
            connectifInternal.sendCustomEventById(eventId, payload, callbacks)
        } catch (e: Exception) {
            handleInternalError(e)
        }
    }

    override fun sendCustomEventByAlias(
        eventAlias: String,
        customEvent: CustomEvent,
        callbacks: EventCallbacks?
    ) {
        try {
            connectifInternal.sendCustomEventByAlias(eventAlias, customEvent, callbacks)
        } catch (e: Exception) {
            handleInternalError(e)
        }
    }

    override fun sendCustomEventByAlias(
        eventAlias: String,
        payload: Any,
        callbacks: EventCallbacks?
    ) {
        try {
            connectifInternal.sendCustomEventByAlias(eventAlias, payload, callbacks)
        } catch (e: Exception) {
            handleInternalError(e)
        }
    }

    internal fun trackPushClick(trackPushClickData: TrackPushClickData?) {
        try {
            connectifInternal.trackPushClick(trackPushClickData)
        } catch (e: Exception) {
            handleInternalError(e)
        }
    }

    private fun handleInternalError(e: Exception) {
        Logger.e("Error occurred: ${e.localizedMessage}")
    }
}
