/*
 * Decompiled with CFR 0.152.
 */
package a.yumi.lib.base.bus;

import a.yumi.lib.base.util.log.LogUtil;
import android.arch.lifecycle.LifecycleOwner;
import android.arch.lifecycle.LiveData;
import android.arch.lifecycle.MutableLiveData;
import android.arch.lifecycle.Observer;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010%\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u00c6\u0002\u0018\u00002\u00020\u0001:\u0002\f\rB\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J(\u0010\u0007\u001a\b\u0012\u0004\u0012\u0002H\b0\u0006\"\u0004\b\u0000\u0010\b2\u0006\u0010\t\u001a\u00020\u00052\f\u0010\n\u001a\b\u0012\u0004\u0012\u0002H\b0\u000bR\u001e\u0010\u0003\u001a\u0012\u0012\u0004\u0012\u00020\u0005\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00060\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"La/yumi/lib/base/bus/YLiveDataBus;", "", "()V", "bus", "", "", "Landroid/arch/lifecycle/MutableLiveData;", "with", "T", "key", "type", "Ljava/lang/Class;", "BusMutableLiveData", "ObserverWrapper", "lib_base_release"})
public final class YLiveDataBus {
    private static final Map<String, MutableLiveData<?>> bus;
    public static final YLiveDataBus INSTANCE;

    @NotNull
    public final <T> MutableLiveData<T> with(@NotNull String key, @NotNull Class<T> type) {
        Intrinsics.checkParameterIsNotNull((Object)key, (String)"key");
        Intrinsics.checkParameterIsNotNull(type, (String)"type");
        if (!bus.containsKey(key)) {
            bus.put(key, new BusMutableLiveData());
        }
        MutableLiveData<?> mutableLiveData = bus.get(key);
        if (mutableLiveData == null) {
            throw new TypeCastException("null cannot be cast to non-null type android.arch.lifecycle.MutableLiveData<T>");
        }
        return mutableLiveData;
    }

    private YLiveDataBus() {
    }

    static {
        YLiveDataBus yLiveDataBus;
        INSTANCE = yLiveDataBus = new YLiveDataBus();
        bus = new HashMap();
    }

    @Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\b\u0002\u0018\u0000*\u0004\b\u0000\u0010\u00012\b\u0012\u0004\u0012\u0002H\u00010\u0002B\u0013\u0012\f\u0010\u0003\u001a\b\u0012\u0004\u0012\u00028\u00000\u0002\u00a2\u0006\u0002\u0010\u0004J\b\u0010\u0005\u001a\u00020\u0006H\u0002J\u0017\u0010\u0007\u001a\u00020\b2\b\u0010\t\u001a\u0004\u0018\u00018\u0000H\u0016\u00a2\u0006\u0002\u0010\nR\u0014\u0010\u0003\u001a\b\u0012\u0004\u0012\u00028\u00000\u0002X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000b"}, d2={"La/yumi/lib/base/bus/YLiveDataBus$ObserverWrapper;", "T", "Landroid/arch/lifecycle/Observer;", "observer", "(Landroid/arch/lifecycle/Observer;)V", "isCallOnObserve", "", "onChanged", "", "t", "(Ljava/lang/Object;)V", "lib_base_release"})
    private static final class ObserverWrapper<T>
    implements Observer<T> {
        private Observer<T> observer;

        public void onChanged(@Nullable T t) {
            if (this.isCallOnObserve()) {
                return;
            }
            this.observer.onChanged(t);
        }

        private final boolean isCallOnObserve() {
            StackTraceElement[] stackTrace;
            Thread thread = Thread.currentThread();
            Intrinsics.checkExpressionValueIsNotNull((Object)thread, (String)"Thread.currentThread()");
            if (stackTrace != null) {
                StackTraceElement[] $this$forEach$iv = stackTrace = thread.getStackTrace();
                boolean $i$f$forEach = false;
                StackTraceElement[] stackTraceElementArray = $this$forEach$iv;
                int n = stackTraceElementArray.length;
                for (int i = 0; i < n; ++i) {
                    StackTraceElement element$iv;
                    StackTraceElement it = element$iv = stackTraceElementArray[i];
                    boolean bl = false;
                    StackTraceElement stackTraceElement = it;
                    Intrinsics.checkExpressionValueIsNotNull((Object)stackTraceElement, (String)"it");
                    if (!Intrinsics.areEqual((Object)stackTraceElement.getClassName(), (Object)"android.arch.lifecycle.LiveData") || !Intrinsics.areEqual((Object)it.getMethodName(), (Object)"observeForever")) continue;
                    return true;
                }
            }
            return false;
        }

        public ObserverWrapper(@NotNull Observer<T> observer) {
            Intrinsics.checkParameterIsNotNull(observer, (String)"observer");
            this.observer = observer;
        }
    }

    @Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000,\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0002\u0018\u0000*\u0004\b\u0000\u0010\u00012\b\u0012\u0004\u0012\u0002H\u00010\u0002B\u0005\u00a2\u0006\u0002\u0010\u0003J\u0016\u0010\b\u001a\u00020\t2\f\u0010\n\u001a\b\u0012\u0004\u0012\u00028\u00000\u0006H\u0002J\u001e\u0010\u000b\u001a\u00020\t2\u0006\u0010\f\u001a\u00020\r2\f\u0010\n\u001a\b\u0012\u0004\u0012\u00028\u00000\u0006H\u0016J\u0016\u0010\u000e\u001a\u00020\t2\f\u0010\n\u001a\b\u0012\u0004\u0012\u00028\u00000\u0006H\u0016J\u0016\u0010\u000f\u001a\u00020\t2\f\u0010\n\u001a\b\u0012\u0004\u0012\u00028\u00000\u0006H\u0016R:\u0010\u0004\u001a.\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u0006\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00060\u0005j\u0016\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u0006\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u0006`\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"La/yumi/lib/base/bus/YLiveDataBus$BusMutableLiveData;", "T", "Landroid/arch/lifecycle/MutableLiveData;", "()V", "observerMap", "Ljava/util/HashMap;", "Landroid/arch/lifecycle/Observer;", "Lkotlin/collections/HashMap;", "hook", "", "observer", "observe", "owner", "Landroid/arch/lifecycle/LifecycleOwner;", "observeForever", "removeObserver", "lib_base_release"})
    private static final class BusMutableLiveData<T>
    extends MutableLiveData<T> {
        private final HashMap<Observer<?>, Observer<?>> observerMap = new HashMap();

        public void observe(@NotNull LifecycleOwner owner, @NotNull Observer<T> observer) {
            Intrinsics.checkParameterIsNotNull((Object)owner, (String)"owner");
            Intrinsics.checkParameterIsNotNull(observer, (String)"observer");
            super.observe(owner, observer);
            try {
                this.hook(observer);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }

        public void observeForever(@NotNull Observer<T> observer) {
            Intrinsics.checkParameterIsNotNull(observer, (String)"observer");
            LogUtil.loge("observeForever " + this.observerMap.size());
            if (!this.observerMap.containsKey(observer)) {
                ((Map)this.observerMap).put(observer, new ObserverWrapper<T>(observer));
            }
            Observer<?> observer2 = this.observerMap.get(observer);
            if (observer2 == null) {
                throw new TypeCastException("null cannot be cast to non-null type android.arch.lifecycle.Observer<T>");
            }
            super.observeForever(observer2);
        }

        public void removeObserver(@NotNull Observer<T> observer) {
            Object object;
            Intrinsics.checkParameterIsNotNull(observer, (String)"observer");
            if (this.observerMap.containsKey(observer)) {
                Observer<?> observer2 = this.observerMap.remove(observer);
                if (observer2 == null) {
                    throw new TypeCastException("null cannot be cast to non-null type android.arch.lifecycle.Observer<T>");
                }
                object = observer2;
            } else {
                object = observer;
            }
            Observer<T> realObserver = object;
            super.removeObserver(realObserver);
        }

        private final void hook(Observer<T> observer) {
            Field fieldVersion;
            Field fieldLastVersion;
            Method methodGet;
            Field fieldObservers;
            Class<LiveData> liveDataClass = LiveData.class;
            Field field = fieldObservers = liveDataClass.getDeclaredField("mObservers");
            Intrinsics.checkExpressionValueIsNotNull((Object)field, (String)"fieldObservers");
            field.setAccessible(true);
            Object observers = fieldObservers.get((Object)this);
            Class<?> classObservers = observers.getClass();
            Method method = methodGet = classObservers.getDeclaredMethod("get", Object.class);
            Intrinsics.checkExpressionValueIsNotNull((Object)method, (String)"methodGet");
            method.setAccessible(true);
            Object objectWrapperEntry = methodGet.invoke(observers, observer);
            Object objectWrapper = null;
            if (objectWrapperEntry instanceof Map.Entry) {
                objectWrapper = ((Map.Entry)objectWrapperEntry).getValue();
            }
            if (objectWrapper == null) {
                throw (Throwable)new NullPointerException("Wrapper can not be bull!");
            }
            Class<?> observerWrapperClass = objectWrapper.getClass().getSuperclass();
            Field field2 = fieldLastVersion = observerWrapperClass.getDeclaredField("mLastVersion");
            Intrinsics.checkExpressionValueIsNotNull((Object)field2, (String)"fieldLastVersion");
            field2.setAccessible(true);
            Field field3 = fieldVersion = liveDataClass.getDeclaredField("mVersion");
            Intrinsics.checkExpressionValueIsNotNull((Object)field3, (String)"fieldVersion");
            field3.setAccessible(true);
            Object objectVersion = fieldVersion.get((Object)this);
            fieldLastVersion.set(objectWrapper, objectVersion);
        }
    }
}

