package a.yumi.lib.base.util

import a.yumi.lib.base.util.log.loge
import android.Manifest
import android.app.Activity
import com.tbruyelle.rxpermissions2.RxPermissions

/**
 * name
 * describe
 * Created by SHEN on 2017/11/20.
 */
object RxPermissionsUtil {
    private fun requestSingle(activity: Activity, permission: String, granted: () -> Unit = {}, errorHint: String = "请允许获取权限") {
        RxPermissions(activity)
                .requestEach(permission)
                .subscribe {
                    when {
                        it.granted -> {
                            granted()
                        }
                        else -> loge(errorHint)
                    }
                }
    }

    private fun requestMulti(activity: Activity, vararg permissions: String, granted: () -> Unit = {}, errorHint: String = "请允许获取权限") {
        RxPermissions(activity)
                .request(*permissions)
                .subscribe {
                    when {
                        it -> {
                            granted()
                        }
                        else -> loge(errorHint)
                    }
                }
    }

    /**
     * 手机存储
     */
    fun writeExternalStorage(activity: Activity, granted: () -> Unit) {
        requestSingle(
                activity,
                Manifest.permission.WRITE_EXTERNAL_STORAGE,
                granted,
                "请允许 读写手机存储 权限")
    }

    /**
     * 相册
     */
    @JvmStatic
    fun openAlbum(activity: Activity, granted: () -> Unit) {
        val permissions = arrayOf(
                Manifest.permission.CAMERA,
                Manifest.permission.WRITE_EXTERNAL_STORAGE,
                Manifest.permission.READ_EXTERNAL_STORAGE
        )
        requestMulti(
                activity = activity,
                permissions = *permissions,
                granted = granted,
                errorHint = "请允许 拍照和读写手机存储 权限")
    }

    /**
     * 相机
     */
    @JvmStatic
    fun openCamera(activity: Activity, granted: () -> Unit) {
        val permissions = arrayOf(
                Manifest.permission.CAMERA
        )
        requestMulti(
                activity = activity,
                permissions = *permissions,
                granted = granted,
                errorHint = "请允许 拍照和读写手机存储 权限")
    }

    /**
     * 获取目前系统所需的全部权限
     */
    @JvmStatic
    @JvmOverloads
    fun requestAll(activity: Activity, granted: () -> Unit = {}) {
        val permissions = arrayOf(
                Manifest.permission.CAMERA,
                Manifest.permission.WRITE_EXTERNAL_STORAGE,
                Manifest.permission.READ_EXTERNAL_STORAGE,
                Manifest.permission.READ_PHONE_STATE,
                Manifest.permission.ACCESS_WIFI_STATE,
                Manifest.permission.ACCESS_NETWORK_STATE,
                Manifest.permission.ACCESS_FINE_LOCATION,
                Manifest.permission.ACCESS_COARSE_LOCATION
        )
        requestMulti(
                activity = activity,
                permissions = *permissions,
                granted = granted,
                errorHint = "请允许 相应的 权限")
    }

}