package a.yumi.lib.base.util

import a.yumi.lib.base.R
import android.os.Environment
import java.io.File

/**
 * // 注意权限
 */
object FileUtil {

    private val bathPath: String
        get() = (Environment.getExternalStorageDirectory().absolutePath + "/Yumi/")
            .apply { mkdirs(this) }

    val appPath: String
        get() = (bathPath + getResString(R.string.app_name) + "/")
            .apply { mkdirs(this) }

    val imagePath: String
        get() = ("$appPath/images/")
            .apply { mkdirs(this) }

    val cachePath: String
        get() = ("$appPath/cache/")
            .apply { mkdirs(this) }


    private fun mkdirs(path: String) {
        // 注意权限
        val f = File(path)
        if (!f.exists()) {
            f.mkdirs()
        }
    }

    val ImgDefaultName: String
        get() = "img_${System.currentTimeMillis()}.jpg"

    val ImgScreenShotName: String
        get() = "screenshot_${System.currentTimeMillis()}.jpg"

}
