package a.yumi.lib.base.ui.simple

import a.yumi.lib.base.R
import a.yumi.lib.base.frame.mvp.BaseMVPActivity
import a.yumi.lib.base.frame.mvp.BaseMVPPresenter
import a.yumi.lib.base.frame.mvp.BaseMVPView
import a.yumi.lib.base.util.dp2px
import a.yumi.lib.base.widget.swipetoload.decoration.CommItemGirdDecoration
import a.yumi.lib.base.widget.swipetoload.decoration.SpaceItemDecoration
import android.os.Bundle
import android.support.v7.widget.GridLayoutManager
import android.support.v7.widget.LinearLayoutManager
import android.view.View
import com.chad.library.adapter.base.BaseQuickAdapter
import com.chad.library.adapter.base.BaseViewHolder
import com.chad.library.adapter.base.listener.OnItemClickListener
import kotlinx.android.synthetic.main.ym_simple_btn_test_activity.*

/**
 * PS:
 * Created by sdx on 2019-06-17.
 */
abstract class BaseTestBtnActivity<T> : BaseMVPActivity<BaseMVPView, BaseMVPPresenter<BaseMVPView>>() {
    private val mAdapter = MyAdapter()

    override fun getLayout(): Int = R.layout.ym_simple_btn_test_activity

    override fun initPresenter(): BaseMVPPresenter<BaseMVPView>? = null

    override fun bindView(bundle: Bundle?) {
        recycler_btn.apply {
            layoutManager = GridLayoutManager(this@BaseTestBtnActivity, getSpanCount())
            addItemDecoration(CommItemGirdDecoration(verticalSpace = dp2px(getBtnItemDecorationSpace())))
            addOnItemTouchListener(menuTouchListener)
            adapter = mAdapter
        }
        recycler_show.apply {
            layoutManager = LinearLayoutManager(this@BaseTestBtnActivity)
            addItemDecoration(SpaceItemDecoration(dp2px(getShowItemDecorationSpace())))
            adapter = showAdapter
        }
    }

    override fun initData() {
        toolbar.setTitle(getToolBarTitle())
        mAdapter.setNewData(getBtnData())
    }

    fun setData(data: List<T>?) {
        showAdapter.setNewData(data)
    }

    /**
     * 菜单 点击
     */
    private val menuTouchListener = object : OnItemClickListener() {
        override fun onSimpleItemClick(adapter: BaseQuickAdapter<*, *>, view: View, position: Int) {
            val item = adapter.getItem(position)
            if (item is BaseBtnItem) {
                onClickBtn(item.name)
            }
        }
    }

    private inner class MyAdapter :
        BaseQuickAdapter<BaseBtnItem, BaseViewHolder>(R.layout.ym_simple_btn_item) {

        override fun convert(helper: BaseViewHolder, item: BaseBtnItem) {
            helper.setText(R.id.name_btn, item.name)
        }
    }

    protected open fun getSpanCount(): Int = 4
    protected open fun getBtnItemDecorationSpace(): Float = 5F
    protected open fun getShowItemDecorationSpace(): Float = 1F

    protected abstract fun getToolBarTitle(): String
    protected abstract fun getBtnData(): MutableList<BaseBtnItem>
    protected abstract fun onClickBtn(btn: String)

    protected abstract val showAdapter: BaseQuickAdapter<T, BaseViewHolder>
}