package a.yumi.lib.base.http

import a.yumi.lib.base.util.log.loge
import io.reactivex.annotations.NonNull
import okhttp3.ResponseBody
import retrofit2.Call
import retrofit2.Callback
import retrofit2.Response
import retrofit2.Retrofit
import java.io.*
import java.util.concurrent.Executors


object DownloadUtil {
    fun download(url: String, path: String, downloadListener: DownloadListener) {

        val retrofit = Retrofit.Builder()
            .baseUrl("http://www.xxx.com")
            //通过线程池获取一个线程，指定callback在子线程中运行。
            .callbackExecutor(Executors.newSingleThreadExecutor())
            .build()

        val service = retrofit.create(DownloadService::class.java)

        val call = service.download(url)
        call.enqueue(object : Callback<ResponseBody> {
            override fun onFailure(call: Call<ResponseBody>, t: Throwable) {
                loge("onFailure = ")
            }

            override fun onResponse(call: Call<ResponseBody>, response: Response<ResponseBody>) {
                loge("onResponse")
                writeResponseToDisk(path, response, downloadListener);
            }
        })
    }

    private val sBufferSize = 8192

    private fun writeResponseToDisk(
        path: String,
        response: Response<ResponseBody>,
        downloadListener: DownloadListener
    ) {
        //从response获取输入流以及总大小
        writeFileFromIS(File(path), response.body()!!.byteStream(), response.body()!!.contentLength(), downloadListener)
    }

    //将输入流写入文件
    private fun writeFileFromIS(file: File, `is`: InputStream, totalLength: Long, downloadListener: DownloadListener) {
        //开始下载
        downloadListener.onStart()

        //创建文件
        if (!file.exists()) {
            if (!file.parentFile.exists())
                file.parentFile.mkdir()
            try {
                file.createNewFile()
            } catch (e: IOException) {
                e.printStackTrace()
                downloadListener.onFail("createNewFile IOException")
            }

        }

        var os: OutputStream? = null
        var currentLength: Long = 0
        try {
            os = BufferedOutputStream(FileOutputStream(file))
            val data = ByteArray(sBufferSize)
            var len: Int = `is`.read(data, 0, sBufferSize)
            while (len != -1) {
                os.write(data, 0, len)
                currentLength += len.toLong()
                //计算当前下载进度
                downloadListener.onProgress((100 * currentLength / totalLength).toInt())
                len = `is`.read(data, 0, sBufferSize)
            }
            //下载完成，并返回保存的文件路径
            downloadListener.onFinish(file.absolutePath)
        } catch (e: IOException) {
            e.printStackTrace()
            downloadListener.onFail("IOException")
        } finally {
            try {
                `is`.close()
            } catch (e: IOException) {
                e.printStackTrace()
            }

            try {
                if (os != null) {
                    os!!.close()
                }
            } catch (e: IOException) {
                e.printStackTrace()
            }

        }
    }
}