package a.yumi.lib.base

import a.yumi.lib.base.util.log.logJson
import a.yumi.lib.base.util.log.loge
import a.yumi.lib.base.util.log.logi
import android.content.Context
import com.alibaba.android.arouter.facade.Postcard
import com.alibaba.android.arouter.facade.annotation.Interceptor
import com.alibaba.android.arouter.facade.callback.InterceptorCallback
import com.alibaba.android.arouter.facade.template.IInterceptor

/**
 * PS:
 * Created by sdx on 2019-06-24.
 */
// 比较经典的应用就是在跳转过程中处理登陆事件，这样就不需要在目标页重复做登陆检查
// 拦截器会在跳转之间执行，多个拦截器会按优先级顺序依次执行
@Interceptor(priority = 8, name = "测试用拦截器")
class TestInterceptor : IInterceptor {
    override fun init(context: Context) {
        loge("TestInterceptor init priority = 8")
        // 拦截器的初始化，会在sdk初始化的时候调用该方法，仅会调用一次
    }

    override fun process(postcard: Postcard, callback: InterceptorCallback) {
        logJson("TestInterceptor", postcard.extras)
        callback.onContinue(postcard)  // 处理完成，交还控制权
//         callback.onInterrupt( RuntimeException("我觉得有点异常"));      // 觉得有问题，中断路由流程
        // 以上两种至少需要调用其中一种，否则不会继续路由
    }
}

@Interceptor(priority = 7, name = "测试用拦截器2")
class TestInterceptor2 : IInterceptor {
    override fun init(context: Context) {
        loge("TestInterceptor init priority = 7")
        // 拦截器的初始化，会在sdk初始化的时候调用该方法，仅会调用一次
    }

    override fun process(postcard: Postcard, callback: InterceptorCallback) {
        logi("TestInterceptor process 7 ${postcard.extras}")
        callback.onContinue(postcard)  // 处理完成，交还控制权
//         callback.onInterrupt( RuntimeException("我觉得有点异常"));      // 觉得有问题，中断路由流程
        // 以上两种至少需要调用其中一种，否则不会继续路由
    }
}

@Interceptor(priority = 6, name = "测试用拦截器3")
class TestInterceptor3 : IInterceptor {
    override fun init(context: Context) {
        loge("TestInterceptor init priority = 6")
        // 拦截器的初始化，会在sdk初始化的时候调用该方法，仅会调用一次
    }

    override fun process(postcard: Postcard, callback: InterceptorCallback) {
        logi("TestInterceptor process 6 ${postcard.extras}")
        callback.onContinue(postcard)  // 处理完成，交还控制权
//         callback.onInterrupt( RuntimeException("我觉得有点异常"));      // 觉得有问题，中断路由流程
        // 以上两种至少需要调用其中一种，否则不会继续路由
    }
}