package a.yumi.lib.base

import a.yumi.lib.base.util.log.initLogUtil
import android.app.Application
import android.support.annotation.Keep
import android.support.multidex.MultiDexApplication
import com.alibaba.android.arouter.launcher.ARouter
import com.tencent.bugly.crashreport.CrashReport
import kotlin.properties.Delegates

/**
 * PS:
 * Created by sdx on 2018/7/6.
 */
@Keep
open class BaseApplication : MultiDexApplication() {

    companion object {
        @JvmStatic
        var context: Application by Delegates.notNull()
    }

    override fun onCreate() {
        super.onCreate()
        context = this
        initBaseApplication()
    }

    private fun initBaseApplication() {
        ARouter.openLog() // 开启日志
        ARouter.openDebug() // 使用InstantRun的时候，需要打开该开关，上线之后关闭，否则有安全风险
        ARouter.printStackTrace() // 打印日志的时候打印线程堆栈
        ARouter.init(this)
        CrashReport.initCrashReport(this, "bf3f1651d4", true)
        initLogUtil(true, "Yumi")
    }
}