/*
 * Decompiled with CFR 0.152.
 */
package a.yumi.jojo.lib.base.util;

import a.yumi.jojo.lib.base.BaseApplication;
import android.app.Application;
import android.content.Context;
import android.content.res.ColorStateList;
import android.content.res.Resources;
import android.graphics.drawable.Drawable;
import android.support.annotation.AnimRes;
import android.support.annotation.ArrayRes;
import android.support.annotation.AttrRes;
import android.support.annotation.ColorRes;
import android.support.annotation.DimenRes;
import android.support.annotation.DrawableRes;
import android.support.annotation.StringRes;
import android.support.v4.content.ContextCompat;
import android.util.DisplayMetrics;
import android.util.TypedValue;
import android.view.animation.Animation;
import android.view.animation.AnimationUtils;
import java.util.Arrays;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=5, d1={"\u0000F\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0007\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0011\n\u0002\u0010\u0000\n\u0002\b\t\u001a\u000e\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u0003\u001a\r\u0010\u0004\u001a\u00020\u0005H\u0002\u00a2\u0006\u0002\b\u0006\u001a\u0018\u0010\u0007\u001a\u00020\u00012\u0006\u0010\b\u001a\u00020\t2\b\b\u0001\u0010\n\u001a\u00020\u0001\u001a\u001a\u0010\u000b\u001a\u0004\u0018\u00010\f2\u0006\u0010\b\u001a\u00020\t2\b\b\u0001\u0010\n\u001a\u00020\u0001\u001a\u0018\u0010\r\u001a\u00020\u00012\u0006\u0010\b\u001a\u00020\t2\b\b\u0001\u0010\n\u001a\u00020\u0001\u001a\u0018\u0010\u000e\u001a\u00020\u00032\u0006\u0010\b\u001a\u00020\t2\b\b\u0001\u0010\n\u001a\u00020\u0001\u001a\r\u0010\u000f\u001a\u00020\u0003H\u0002\u00a2\u0006\u0002\b\u0010\u001a\r\u0010\u0011\u001a\u00020\u0003H\u0002\u00a2\u0006\u0002\b\u0012\u001a\u0012\u0010\u0013\u001a\u0004\u0018\u00010\u00142\b\b\u0001\u0010\u0015\u001a\u00020\u0001\u001a\u0010\u0010\u0016\u001a\u00020\u00012\b\b\u0001\u0010\u0015\u001a\u00020\u0001\u001a\u0010\u0010\u0017\u001a\u00020\u00032\b\b\u0001\u0010\u0015\u001a\u00020\u0001\u001a\u0010\u0010\u0018\u001a\u00020\u00012\b\b\u0001\u0010\u0015\u001a\u00020\u0001\u001a\u0010\u0010\u0019\u001a\u00020\u00012\b\b\u0001\u0010\u0015\u001a\u00020\u0001\u001a\u0012\u0010\u001a\u001a\u0004\u0018\u00010\u001b2\b\b\u0001\u0010\u0015\u001a\u00020\u0001\u001a\u0010\u0010\u001c\u001a\u00020\u001d2\b\b\u0001\u0010\u0015\u001a\u00020\u0001\u001a)\u0010\u001c\u001a\u00020\u001d2\b\b\u0001\u0010\u0015\u001a\u00020\u00012\u0012\u0010\u001e\u001a\n\u0012\u0006\b\u0001\u0012\u00020 0\u001f\"\u00020 \u00a2\u0006\u0002\u0010!\u001a\u001b\u0010\"\u001a\b\u0012\u0004\u0012\u00020\u001d0\u001f2\b\b\u0001\u0010\u0015\u001a\u00020\u0001\u00a2\u0006\u0002\u0010#\u001a\u000e\u0010$\u001a\u00020\u00012\u0006\u0010%\u001a\u00020\u0003\u001a\u000e\u0010&\u001a\u00020\u00012\u0006\u0010%\u001a\u00020\u0003\u001a\u000e\u0010'\u001a\u00020\u00012\u0006\u0010(\u001a\u00020\u0003\u00a8\u0006)"}, d2={"dp2px", "", "dp", "", "getApplication", "Landroid/app/Application;", "getApplication$ResUtil__ResUtilKt", "getAttrColor", "context", "Landroid/content/Context;", "attrRes", "getAttrColorStateList", "Landroid/content/res/ColorStateList;", "getAttrDimen", "getAttrFloatValue", "getDensity", "getDensity$ResUtil__ResUtilKt", "getFontDensity", "getFontDensity$ResUtil__ResUtilKt", "getResAnim", "Landroid/view/animation/Animation;", "id", "getResColor", "getResDimension", "getResDimensionPixelOffset", "getResDimensionPixelSize", "getResDrawable", "Landroid/graphics/drawable/Drawable;", "getResString", "", "formatArgs", "", "", "(I[Ljava/lang/Object;)Ljava/lang/String;", "getResStringArr", "(I)[Ljava/lang/String;", "px2dp", "px", "px2sp", "sp2px", "sp", "lib_base_release"}, xs="a/yumi/jojo/lib/base/util/ResUtil")
final class ResUtil__ResUtilKt {
    private static final Application getApplication$ResUtil__ResUtilKt() {
        return BaseApplication.Companion.getContext();
    }

    @NotNull
    public static final String getResString(@StringRes int id) {
        String s = "";
        try {
            String string = ResUtil__ResUtilKt.getApplication$ResUtil__ResUtilKt().getResources().getString(id);
            Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"getApplication().resources.getString(id)");
            s = string;
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return s;
    }

    @NotNull
    public static final String[] getResStringArr(@ArrayRes int id) {
        boolean $i$f$emptyArray = false;
        String[] arr = new String[]{};
        try {
            String[] stringArray = ResUtil__ResUtilKt.getApplication$ResUtil__ResUtilKt().getResources().getStringArray(id);
            Intrinsics.checkExpressionValueIsNotNull((Object)stringArray, (String)"getApplication().resources.getStringArray(id)");
            arr = stringArray;
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return arr;
    }

    @NotNull
    public static final String getResString(@StringRes int id, Object ... formatArgs) {
        Intrinsics.checkParameterIsNotNull((Object)formatArgs, (String)"formatArgs");
        String s = "";
        try {
            String string = ResUtil__ResUtilKt.getApplication$ResUtil__ResUtilKt().getResources().getString(id, Arrays.copyOf(formatArgs, formatArgs.length));
            Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"getApplication().resourc\u2026etString(id, *formatArgs)");
            s = string;
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return s;
    }

    public static final int getResColor(@ColorRes int id) {
        int color2 = -1;
        try {
            color2 = ContextCompat.getColor((Context)((Context)ResUtil__ResUtilKt.getApplication$ResUtil__ResUtilKt()), (int)id);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return color2;
    }

    public static final float getResDimension(@DimenRes int id) {
        float dimen = 0.0f;
        try {
            dimen = ResUtil__ResUtilKt.getApplication$ResUtil__ResUtilKt().getResources().getDimension(id);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return dimen;
    }

    public static final int getResDimensionPixelOffset(@DimenRes int id) {
        int dimen = 0;
        try {
            dimen = ResUtil__ResUtilKt.getApplication$ResUtil__ResUtilKt().getResources().getDimensionPixelOffset(id);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return dimen;
    }

    public static final int getResDimensionPixelSize(@DimenRes int id) {
        int dimen = 0;
        try {
            dimen = ResUtil__ResUtilKt.getApplication$ResUtil__ResUtilKt().getResources().getDimensionPixelSize(id);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return dimen;
    }

    @Nullable
    public static final Drawable getResDrawable(@DrawableRes int id) {
        Drawable drawable = null;
        try {
            drawable = ContextCompat.getDrawable((Context)((Context)ResUtil__ResUtilKt.getApplication$ResUtil__ResUtilKt()), (int)id);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return drawable;
    }

    @Nullable
    public static final Animation getResAnim(@AnimRes int id) {
        Animation animation = null;
        try {
            animation = AnimationUtils.loadAnimation((Context)((Context)ResUtil__ResUtilKt.getApplication$ResUtil__ResUtilKt()), (int)id);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return animation;
    }

    private static final float getDensity$ResUtil__ResUtilKt() {
        Resources resources = ResUtil__ResUtilKt.getApplication$ResUtil__ResUtilKt().getResources();
        Intrinsics.checkExpressionValueIsNotNull((Object)resources, (String)"getApplication().resources");
        return resources.getDisplayMetrics().density;
    }

    private static final float getFontDensity$ResUtil__ResUtilKt() {
        Resources resources = ResUtil__ResUtilKt.getApplication$ResUtil__ResUtilKt().getResources();
        Intrinsics.checkExpressionValueIsNotNull((Object)resources, (String)"getApplication().resources");
        return resources.getDisplayMetrics().scaledDensity;
    }

    public static final int dp2px(float dp) {
        return (int)((double)(ResUtil__ResUtilKt.getDensity$ResUtil__ResUtilKt() * dp) + 0.5);
    }

    public static final int sp2px(float sp) {
        return (int)((double)(ResUtil__ResUtilKt.getFontDensity$ResUtil__ResUtilKt() * sp) + 0.5);
    }

    public static final int px2dp(float px) {
        return (int)((double)(px / ResUtil__ResUtilKt.getDensity$ResUtil__ResUtilKt()) + 0.5);
    }

    public static final int px2sp(float px) {
        return (int)((double)(px / ResUtil__ResUtilKt.getFontDensity$ResUtil__ResUtilKt()) + 0.5);
    }

    public static final float getAttrFloatValue(@NotNull Context context, @AttrRes int attrRes) {
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        TypedValue typedValue = new TypedValue();
        context.getTheme().resolveAttribute(attrRes, typedValue, true);
        return typedValue.getFloat();
    }

    public static final int getAttrColor(@NotNull Context context, @AttrRes int attrRes) {
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        TypedValue typedValue = new TypedValue();
        context.getTheme().resolveAttribute(attrRes, typedValue, true);
        return typedValue.data;
    }

    @Nullable
    public static final ColorStateList getAttrColorStateList(@NotNull Context context, @AttrRes int attrRes) {
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        TypedValue typedValue = new TypedValue();
        context.getTheme().resolveAttribute(attrRes, typedValue, true);
        return ContextCompat.getColorStateList((Context)context, (int)typedValue.resourceId);
    }

    public static final int getAttrDimen(@NotNull Context context, @AttrRes int attrRes) {
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        TypedValue typedValue = new TypedValue();
        context.getTheme().resolveAttribute(attrRes, typedValue, true);
        int n = typedValue.data;
        Resources resources = context.getResources();
        Intrinsics.checkExpressionValueIsNotNull((Object)resources, (String)"context.resources");
        return TypedValue.complexToDimensionPixelSize((int)n, (DisplayMetrics)resources.getDisplayMetrics());
    }
}

