package a.yumi.jojo.lib.base.widget.swipetoload.decoration

import android.graphics.Canvas
import android.graphics.Color
import android.graphics.Paint
import android.graphics.Rect
import android.support.annotation.ColorInt
import android.support.v7.widget.GridLayoutManager
import android.support.v7.widget.RecyclerView
import android.support.v7.widget.StaggeredGridLayoutManager
import android.view.View

/**
 * 功能描述: RecyclerView gird 中间线颜色高度
 * 只有 中间部分，外圈无
 *
 * @author SDX
 * @company 中储南京智慧物流科技有限公司
 * @copyright （版权）中储南京智慧物流科技有限公司所有
 * @date 2018/11/1
 */
@Suppress("unused")
class CommItemGirdDecoration
/**
 * @param verticalSpace   垂直间隔
 * @param horizontalSpace 水平间隔
 * @param color           间隔颜色
 */
@JvmOverloads
constructor(
    // 垂直间隔
    private val verticalSpace: Int,
    // 水平间隔
    private val horizontalSpace: Int = verticalSpace,
    @ColorInt color: Int = Color.TRANSPARENT
) : RecyclerView.ItemDecoration() {

    private val mPaint: Paint?

    init {
        mPaint = Paint(Paint.ANTI_ALIAS_FLAG)
        mPaint.color = color
        mPaint.style = Paint.Style.FILL
    }

    override fun getItemOffsets(outRect: Rect, view: View, parent: RecyclerView, state: RecyclerView.State) {
        super.getItemOffsets(outRect, view, parent, state)

        val spanCount = getSpanCount(parent)
        val childCount = parent.adapter?.itemCount ?: 0
        var itemPosition: Int = -1

        val layoutParams = view.layoutParams
        if (layoutParams is RecyclerView.LayoutParams) {
            itemPosition = layoutParams.viewLayoutPosition
        }

        val isLastRow = isLastRow(parent, itemPosition, spanCount, childCount)
        val isLastColumn = isLastColumn(parent, itemPosition, spanCount, childCount)

        val left: Int
        var right: Int
        var bottom: Int
        val eachWidth = (spanCount - 1) * verticalSpace / spanCount
        val dl = verticalSpace - eachWidth

        left = itemPosition % spanCount * dl
        right = eachWidth - left
        bottom = horizontalSpace
        if (isLastRow) {
            bottom = 0
        }
        if (isLastColumn) {
            right = 0
        }
        outRect.set(left, 0, right, bottom)
    }

    override fun onDraw(c: Canvas, parent: RecyclerView, state: RecyclerView.State) {
        super.onDraw(c, parent, state)
        draw(c, parent)
    }

    // todo StaggeredGridLayoutManager 情况还需要优化
    //绘制横向 item 分割线
    private fun draw(canvas: Canvas, parent: RecyclerView) {
        val childSize = parent.childCount
        val spanCount = getSpanCount(parent)
        val childCount = parent.adapter?.itemCount ?: 0

        for (i in 0 until childSize) {
            val child = parent.getChildAt(i)

            var itemPosition: Int = -1
            val layoutParams = child.layoutParams as RecyclerView.LayoutParams
            if (layoutParams is GridLayoutManager.LayoutParams) {
                itemPosition = layoutParams.viewLayoutPosition
            } else if (layoutParams is StaggeredGridLayoutManager.LayoutParams) {
                itemPosition = layoutParams.spanIndex
            }

            //画水平分隔线
            var left = child.left.toFloat()
            var right = child.right.toFloat()
            var top = child.bottom.toFloat() + layoutParams.bottomMargin
            var bottom = top + horizontalSpace

            val isLastRow = isLastRow(parent, itemPosition, spanCount, childCount)
            val isLastColumn = isLastColumn(parent, itemPosition, spanCount, childCount)

            if (isLastRow) {
                bottom = top
            } else {
            }
            if (mPaint != null) {
                canvas.drawRect(left, top, right, bottom, mPaint)
            }
            //画垂直分割线
            top = child.top.toFloat()
            bottom = child.bottom.toFloat() + horizontalSpace
            left = child.right.toFloat() + layoutParams.rightMargin
            right = left + verticalSpace
            if (isLastColumn) {
                right = left
            }
            if (isLastRow) {
                bottom = child.bottom.toFloat()
            }
            if (mPaint != null) {
                canvas.drawRect(left, top, right, bottom, mPaint)
            }

        }
    }

    private fun isLastColumn(
        parent: RecyclerView, pos: Int, spanCount: Int,
        childC: Int
    ): Boolean {
        var childCount = childC
        val layoutManager = parent.layoutManager
        if (layoutManager is GridLayoutManager) {
            if ((pos + 1) % spanCount == 0) {
                // 如果是最后一列，则不需要绘制右边
                return true
            }
        } else if (layoutManager is StaggeredGridLayoutManager) {
            val orientation = layoutManager.orientation
            if (orientation == StaggeredGridLayoutManager.VERTICAL) {
                if ((pos + 1) % spanCount == 0) {
                    // 如果是最后一列，则不需要绘制右边
                    return true
                }
            } else {
                childCount -= childCount % spanCount
                if (pos >= childCount) {
                    // 如果是最后一列，则不需要绘制右边
                    return true
                }
            }
        }
        return false
    }

    private fun isLastRow(
        parent: RecyclerView, pos: Int, spanCount: Int,
        childC: Int
    ): Boolean {
        var childCount = childC
        val layoutManager = parent.layoutManager
        if (layoutManager is GridLayoutManager) {
            // childCount = childCount - childCount % spanCount;
            val lines = if (childCount % spanCount == 0) {
                childCount / spanCount
            } else {
                childCount / spanCount + 1
            }
            return lines == pos / spanCount + 1
        } else if (layoutManager is StaggeredGridLayoutManager) {
            val orientation = layoutManager.orientation
            // StaggeredGridLayoutManager 且纵向滚动
            if (orientation == StaggeredGridLayoutManager.VERTICAL) {
                childCount -= childCount % spanCount
                // 如果是最后一行，则不需要绘制底部
                if (pos >= childCount)
                    return true
            } else {
                // 如果是最后一行，则不需要绘制底部
                if ((pos + 1) % spanCount == 0) {
                    return true
                }
            }
        }
        return false
    }

    private fun getSpanCount(parent: RecyclerView): Int {
        // 列数
        var spanCount = -1
        val layoutManager = parent.layoutManager
        if (layoutManager is GridLayoutManager) {
            spanCount = layoutManager.spanCount
        } else if (layoutManager is StaggeredGridLayoutManager) {
            spanCount = layoutManager.spanCount
        }
        return spanCount
    }
}