package a.yumi.jojo.lib.base.widget.swipetoload

import a.yumi.jojo.lib.base.util.dp2px
import a.yumi.jojo.lib.base.widget.swipetoload.decoration.CommItemGirdDecoration
import android.content.Context
import android.support.v7.widget.GridLayoutManager
import android.support.v7.widget.RecyclerView
import android.util.AttributeSet
import com.aspsine.swipetoloadlayout.OnRefreshListener
import com.aspsine.swipetoloadlayout.SwipeToLoadLayout
import com.chad.library.adapter.base.BaseQuickAdapter
import com.chad.library.adapter.base.listener.OnItemClickListener
import com.yumi.jojo.lib.base.R

/**
 * PS:
 * 功能定义：
 * 1、带刷新头，加载尾
 * 2、刷新头、加载尾可独立配置
 * 3、setListener 单方法
 * 4、...
 * Created by sdx on 2019-04-23.
 */
class YMSwipeToLoadLayout : SwipeToLoadLayout {
    companion object {
        //带分页的情况下，默认第一页的页码
        private const val DEFAULT_FIRST_PAGE_NO = 1
    }

    //初始化 页码
    private var mPageNo = DEFAULT_FIRST_PAGE_NO

    private var mIsRefreshEnabled = true
    private var mIsLoadMoreEnabled = true

    var mListener: Listener? = null
    var mAdapter: BaseQuickAdapter<*, *>? = null

    constructor(context: Context) : super(context) {
        init()
    }

    constructor(context: Context, attrs: AttributeSet?) : super(context, attrs) {
        init()
    }

    constructor(context: Context, attrs: AttributeSet?, defStyleAttr: Int) : super(context, attrs, defStyleAttr) {
        init()
    }

    val mRecyclerView: RecyclerView by lazy {
        RecyclerView(context).apply {
            id = R.id.swipe_target
        }
    }

    val mHeaderView: YMRefreshHeaderView by lazy {
        YMRefreshHeaderView(context).apply {
            id = R.id.swipe_refresh_header
            layoutParams = LayoutParams(LayoutParams.MATCH_PARENT, LayoutParams.WRAP_CONTENT)
        }
    }

    private fun init() {
        addView(mHeaderView)
        addView(mRecyclerView)

        setSwipeStyle(STYLE.ABOVE)
    }

    fun setAdapter(adapter: BaseQuickAdapter<*, *>, refreshEnabled: Boolean = true, loadMoreEnabled: Boolean = true) {
        // bind
        mAdapter = adapter
        mRecyclerView.layoutManager = GridLayoutManager(context, 3)
        adapter.openLoadAnimation()
        adapter.bindToRecyclerView(mRecyclerView)

        // ItemDecoration
        mRecyclerView.addItemDecoration(CommItemGirdDecoration(dp2px(8F)))
        // refresh
        isRefreshEnabled = refreshEnabled
        mIsRefreshEnabled = refreshEnabled
        if (isRefreshEnabled) {
            setOnRefreshListener(onRefreshListener)
        } else {
            setOnRefreshListener(null)
        }
        // load more
        mIsLoadMoreEnabled = loadMoreEnabled
        if (loadMoreEnabled) {
            adapter.disableLoadMoreIfNotFullPage()
            adapter.setEnableLoadMore(true)
            adapter.setPreLoadNumber(2)
            adapter.setOnLoadMoreListener(onLoadMoreListener, mRecyclerView)
        } else {
            adapter.setEnableLoadMore(false)
            adapter.setOnLoadMoreListener(null, mRecyclerView)
        }
    }

    fun setAdapterData(data: List<*>?) {
        if (data == null || data.isEmpty()) {
            isRefreshing = false
            mAdapter?.loadMoreEnd()
            return
        }
        val list = data as? List<Nothing> ?: return
        when (mPageNo) {
            1 -> {
                mAdapter?.setNewData(list)
                isRefreshing = false
            }
            else -> {
                mAdapter?.addData(list)
                mAdapter?.loadMoreComplete()
            }
        }
    }

    fun autoRefresh() {
        isRefreshing = true
    }

    fun addOnItemListener(onItemClickListener: OnItemClickListener) {
        mRecyclerView.addOnItemTouchListener(onItemClickListener)
    }

    private val onRefreshListener = OnRefreshListener {
        mPageNo = DEFAULT_FIRST_PAGE_NO
        mListener?.getDataByPage(mPageNo)
    }

    private val onLoadMoreListener = BaseQuickAdapter.RequestLoadMoreListener {
        mListener?.getDataByPage(++mPageNo)
    }

    interface Listener {
        fun getDataByPage(pageStart1: Int)
    }
}