@file:JvmMultifileClass
@file:JvmName("ImageUtil")

package a.yumi.jojo.lib.base.util.img

import android.content.Context
import android.support.annotation.DrawableRes
import android.widget.ImageView
import com.bumptech.glide.Glide
import com.bumptech.glide.RequestManager
import java.io.File

private fun getGlide(context: Context): RequestManager {
    return Glide.with(context)
}

// ------------------loadUrl--------------------------------------------------------------------------------------------

@JvmOverloads
fun ImageView.loadUrl(
        url: String,
        @DrawableRes placeholder: Int = 0,
        @DrawableRes error: Int = 0
) {
    getGlide(context)
            .load(url)
            .placeholder(placeholder)
            .error(error)
            .dontAnimate()
            .into(this)
}

// ------------------loadRes--------------------------------------------------------------------------------------------

@JvmOverloads
fun ImageView.loadRes(
        @DrawableRes res: Int,
        @DrawableRes placeholder: Int = 0,
        @DrawableRes error: Int = 0
) {
    getGlide(context)
            .load(res)
            .placeholder(placeholder)
            .error(error)
            .dontAnimate()
            .into(this)
}

// ------------------loadFile--------------------------------------------------------------------------------------------

@JvmOverloads
fun ImageView.loadFile(
        file: String,
        @DrawableRes placeholder: Int = 0,
        @DrawableRes error: Int = 0
) {
    getGlide(context)
            .load("file://$file")
            .placeholder(placeholder)
            .error(error)
            .dontAnimate()
            .into(this)
}

@JvmOverloads
fun ImageView.loadFile(
        file: File,
        @DrawableRes placeholder: Int = 0,
        @DrawableRes error: Int = 0
) {
    getGlide(context)
            .load(file)
            .placeholder(placeholder)
            .error(error)
            .dontAnimate()
            .into(this)
}

// ------------------loadRes--------------------------------------------------------------------------------------------

@JvmOverloads
fun ImageView.loadGif(
        @DrawableRes gifResId: Int,
        @DrawableRes placeholder: Int = 0
) {
    getGlide(context)
            .asGif()
            .load(gifResId)
//        .asGif() //只能加载gif， 加载其他的报错，当然也可以不设置asGif，同样可以加载gif
//                .diskCacheStrategy(DiskCacheStrategy.SOURCE)
            .placeholder(placeholder)
            .dontAnimate()
            .into(this)
}