@file:JvmMultifileClass
@file:JvmName("ResUtil")

package a.yumi.jojo.lib.base.util

/**
 * Title: ResUtils
 * app资源utils
 * @author SDX
 */

import android.app.Application
import android.content.Context
import android.content.res.ColorStateList
import android.graphics.drawable.Drawable
import android.support.annotation.*
import android.support.v4.content.ContextCompat
import android.util.TypedValue
import android.view.animation.Animation
import android.view.animation.AnimationUtils


private fun getApplication(): Application {
    return a.yumi.jojo.lib.base.BaseApplication.context
}

// **************************************************
//      res
// **************************************************

fun getResString(@StringRes id: Int): String {
    var s = ""
    try {
        s = getApplication().resources.getString(id)
    } catch (e: Exception) {
        e.printStackTrace()
    }
    return s
}

fun getResStringArr(@ArrayRes id: Int): Array<String> {
    var arr = emptyArray<String>()
    try {
        arr = getApplication().resources.getStringArray(id)
    } catch (e: Exception) {
        e.printStackTrace()
    }
    return arr
}

fun getResString(@StringRes id: Int, vararg formatArgs: Any): String {
    var s = ""
    try {
        s = getApplication().resources.getString(id, *formatArgs)
    } catch (e: Exception) {
        e.printStackTrace()
    }
    return s
}

fun getResColor(@ColorRes id: Int): Int {
    var color = -1
    try {
        color = ContextCompat.getColor(getApplication(), id)
    } catch (e: Exception) {
        e.printStackTrace()
    }
    return color
}

/**
 * 如果单位是dp或sp，则需要将其乘以density 如果是px，则不乘
 */
fun getResDimension(@DimenRes id: Int): Float {
    var dimen = 0F
    try {
        dimen = getApplication().resources.getDimension(id)
    } catch (e: Exception) {
        e.printStackTrace()
    }
    return dimen
}

/**
 * 如果单位是dp或sp，则需要将其乘以density 如果是px，则不乘
 */
fun getResDimensionPixelOffset(@DimenRes id: Int): Int {
    var dimen = 0
    try {
        dimen = getApplication().resources.getDimensionPixelOffset(id)
    } catch (e: Exception) {
        e.printStackTrace()
    }
    return dimen
}

/**
 * 不管写的是dp还是sp还是px,都会乘以density
 */
fun getResDimensionPixelSize(@DimenRes id: Int): Int {
    var dimen = 0
    try {
        dimen = getApplication().resources.getDimensionPixelSize(id)
    } catch (e: Exception) {
        e.printStackTrace()
    }
    return dimen
}

fun getResDrawable(@DrawableRes id: Int): Drawable? {
    var drawable: Drawable? = null
    try {
        drawable = ContextCompat.getDrawable(getApplication(), id)
    } catch (e: Exception) {
        e.printStackTrace()
    }
    return drawable
}

fun getResAnim(@AnimRes id: Int): Animation? {
    var animation: Animation? = null
    try {
        animation = AnimationUtils.loadAnimation(getApplication(), id)
    } catch (e: Exception) {
    }
    return animation
}

// **************************************************
//      dp sp px map
// **************************************************

private fun getDensity(): Float {
    return getApplication().resources.displayMetrics.density
}

private fun getFontDensity(): Float {
    return getApplication().resources.displayMetrics.scaledDensity
}

/**
 * 单位转换: dp -> px
 */
fun dp2px(dp: Float): Int {
    return (getDensity() * dp + 0.5).toInt()
}

/**
 * 单位转换: sp -> px
 */
fun sp2px(sp: Float): Int {
    return (getFontDensity() * sp + 0.5).toInt()
}

/**
 * 单位转换:px -> dp
 */
fun px2dp(px: Float): Int {
    return (px / getDensity() + 0.5).toInt()
}

/**
 * 单位转换:px -> sp
 */
fun px2sp(px: Float): Int {
    return (px / getFontDensity() + 0.5).toInt()
}

// **************************************************
//      attrs
// **************************************************

fun getAttrFloatValue(context: Context, @AttrRes attrRes: Int): Float {
    val typedValue = TypedValue()
    context.theme.resolveAttribute(attrRes, typedValue, true)
    return typedValue.float
}

fun getAttrColor(context: Context, @AttrRes attrRes: Int): Int {
    val typedValue = TypedValue()
    context.theme.resolveAttribute(attrRes, typedValue, true)
    return typedValue.data
}

fun getAttrColorStateList(context: Context, @AttrRes attrRes: Int): ColorStateList? {
    val typedValue = TypedValue()
    context.theme.resolveAttribute(attrRes, typedValue, true)
    return ContextCompat.getColorStateList(context, typedValue.resourceId)
}

//fun getAttrDrawable(context: Context, attrRes: Int): Drawable? {
//    val attrs = intArrayOf(attrRes)
//    val ta = context.obtainStyledAttributes(attrs)
//    val drawable = getAttrDrawable(context, ta, 0)
//    ta.recycle()
//    return drawable
//}
//
//fun getAttrDrawable(context: Context, typedArray: TypedArray, index: Int): Drawable? {
//    val value = typedArray.peekValue(index)
//    if (value != null) {
//        if (value.type != TypedValue.TYPE_ATTRIBUTE && value.resourceId != 0) {
//            return QMUIDrawableHelper.getVectorDrawable(context, value.resourceId)
//        }
//    }
//    return null
//}

fun getAttrDimen(context: Context, @AttrRes attrRes: Int): Int {
    val typedValue = TypedValue()
    context.theme.resolveAttribute(attrRes, typedValue, true)
    return TypedValue.complexToDimensionPixelSize(typedValue.data, context.resources.displayMetrics)
}