package a.yumi.jojo.lib.base.ui


import a.yumi.jojo.lib.base.util.dp2px
import android.os.Bundle
import android.support.annotation.LayoutRes
import android.support.annotation.StyleRes
import android.support.v4.app.DialogFragment
import android.support.v4.app.Fragment
import android.support.v4.app.FragmentActivity
import android.support.v4.app.FragmentManager
import android.view.*
import com.yumi.jojo.lib.base.R

/**
 * baseDialog 基类
 */
abstract class BaseDialog : DialogFragment() {

    private var mRootView: View? = null

    internal var window: Window? = null

    protected val dialogType: DialogType
        get() = DialogType.mid

    protected val isCancelableOnTouchOutside: Boolean
        get() = true

    protected abstract val dialogTag: String //获取dialog的标签

    @get:LayoutRes
    protected abstract val dialogLayout: Int //获取dialog的布局

    protected val dialogStyle: Int
        @StyleRes
        get() = R.style.BaseDialog //获取dialog的风格

    enum class DialogType {
        mid, bottom, top, full
    }

    override fun onCreate(savedInstanceState: Bundle?) {
        super.onCreate(savedInstanceState)
        setStyle(DialogFragment.STYLE_NORMAL, dialogStyle)
    }

    override fun onCreateView(
        inflater: LayoutInflater, container: ViewGroup?,
        savedInstanceState: Bundle?
    ): View? {
        if (mRootView == null) {
            mRootView = inflater.inflate(dialogLayout, container)
            window = dialog.window
        } else {
            val parent = mRootView!!.parent as ViewGroup
            parent?.removeView(mRootView)
        }
        return mRootView
    }

    override fun onViewCreated(view: View, savedInstanceState: Bundle?) {
        super.onViewCreated(view, savedInstanceState)
        build(dialogType)
        this.dialog.setCanceledOnTouchOutside(false)
        bindView(view, savedInstanceState)
    }

    /**
     * 绑定视图
     *
     * @param view
     * @param bundle savedInstanceState
     */
    protected abstract fun bindView(view: View, bundle: Bundle?)

    protected fun reAdjustView(marginXDp: Int, marginYDp: Int) {
        val window = dialog.window
        if (null != window) {
            val marginX = dp2px(marginXDp.toFloat())
            val marginY = dp2px(marginYDp.toFloat())
            //设置间距
            window.decorView.setPadding(marginX, marginY, marginX, marginY)
            val lp = window.attributes
            lp.width = WindowManager.LayoutParams.MATCH_PARENT
            lp.height = WindowManager.LayoutParams.WRAP_CONTENT
            window.attributes = lp
        }
    }

    /**
     * 再次根据选择的类型进行布局设置
     *
     * @param type 风格
     * @return dialog
     */
    protected fun build(type: DialogType): BaseDialog {
        when (type) {
            BaseDialog.DialogType.mid -> {
            }
            BaseDialog.DialogType.bottom -> initBottomDialog()
            BaseDialog.DialogType.top -> initTopDialog()
            BaseDialog.DialogType.full -> initFullDialog()
            else -> {
            }
        }
        return this
    }

    private fun initFullDialog() {
        if (null != window) {
            //消除边距
            window!!.decorView.setPadding(0, 0, 0, 0)
            val lp = window!!.attributes
            lp.width = WindowManager.LayoutParams.MATCH_PARENT
            lp.height = WindowManager.LayoutParams.MATCH_PARENT
            window!!.attributes = lp
        }
    }

    protected fun initTopDialog() {
        if (null != window) {
            window!!.decorView.setPadding(0, 0, 0, 0) //消除边距
            val lp = window!!.attributes
            lp.width = WindowManager.LayoutParams.MATCH_PARENT
            lp.height = WindowManager.LayoutParams.WRAP_CONTENT
            //设置dialog的位置在底部
            lp.gravity = Gravity.TOP
            window!!.attributes = lp
            window!!.setGravity(Gravity.TOP)
        }
    }

    protected fun initBottomDialog() {
        if (null != window) {
            //消除边距
            window!!.decorView.setPadding(0, 0, 0, 0)
            val lp = window!!.attributes
            lp.width = WindowManager.LayoutParams.MATCH_PARENT
            lp.height = WindowManager.LayoutParams.WRAP_CONTENT
            //设置dialog的位置在底部
            lp.gravity = Gravity.BOTTOM
            window!!.attributes = lp
            window!!.setGravity(Gravity.BOTTOM)
        }
    }

    fun setAnimations(@StyleRes animationId: Int) {
        if (null != window) {
            window!!.setWindowAnimations(animationId)
        }
    }

    fun show(activity: FragmentActivity) {
        if (null != this.dialog && this.dialog.isShowing) {
            return
        }
        show(activity.supportFragmentManager)
    }

    fun show(fragment: Fragment) {
        if (null != this.dialog && this.dialog.isShowing) {
            return
        }
        show(fragment.fragmentManager)
    }

    fun show(fm: FragmentManager?) {
        val ft = fm!!.beginTransaction()
        ft.add(this, dialogTag)
        ft.commitAllowingStateLoss()
    }

    override fun onViewStateRestored(savedInstanceState: Bundle?) {
        super.onViewStateRestored(savedInstanceState)
        this.dialog.setCanceledOnTouchOutside(isCancelableOnTouchOutside)
        this.dialog.setCancelable(isCancelable)
    }

    override fun dismiss() {
        if (null == this.dialog || !this.dialog.isShowing) {
            return
        }
        super.dismissAllowingStateLoss()
    }

}
